var ARCSEditor = ARCSEditor || {};

var baseUrl, requireMarkup;

var application;

requireMarkup = document.querySelector('[data-main]');

if (requireMarkup !== undefined) {
    baseUrl = requireMarkup.dataset.baseUrl ;
}


ARCSEditor.populateComponents = function(elt) {
    var clist = application.getComponentList();
    var i, option;
    elt.innerHTML = '';
    for (i = 0; i < clist.length; i++) {
        option = document.createElement("option");
        option.text = escape(clist[i]);
        elt.add(option);
    }
};

ARCSEditor.populateSlots = function(elt,cmpName) {
    var cmp = application.getComponent(cmpName);
    var slist = cmp.slots;
    var slotList = elt;
    var i, option;
    slotList.innerHTML = '';
    for (i = 0; i < slist.length; i++) {
        option = document.createElement("option");
        option.text = escape(slist[i]);
        slotList.add(option);
    }        
};

ARCSEditor.manageTabs = function (elt) {
    var children = elt.parentNode.childNodes;
    var i, linkedElement;
            
    for ( i = 0; i < children.length; i++ ) {
        if (children[i].tagName !== undefined) {
            if (children[i].tagName.toLowerCase() === "li") {
                linkedElement = document.querySelector(children[i].dataset.content);
                
                if (children[i] === elt) {            
                    children[i].classList.add("active");
                    linkedElement.classList.add("unmask");
                    linkedElement.classList.remove("mask");
                } else {
                    children[i].classList.remove("active");
                    linkedElement.classList.remove("unmask");
                    linkedElement.classList.add("mask");
                }
            }
        }
    }    
};


require( ['arcs'], function(ARCS) {
    // first, create an application
    application = new ARCS.Application();
    var dialogs = {};

    if (baseUrl) {
        require.config( { baseUrl: baseUrl });
    }

    ARCSEditor.componentDialog = new ARCSEditor.Dialog(
        new ARCSEditor.ComponentDialogData(application)
    );
    
    ARCSEditor.invocationDialog = new ARCSEditor.Dialog(
        new ARCSEditor.InvocationDialogData(application)
    );
    
    ARCSEditor.connectionDialog = new ARCSEditor.Dialog(
        new ARCSEditor.ConnectionDialogData(application)
    );
    
    ARCSEditor.sheetCreationDialog = new ARCSEditor.Dialog( {
        selector: "#newsheet-dialog",
        replacements: [
            { selector: "#ok", key: "onclick", value: function() { 
                var sn = document.getElementById("sheetname");
                if (sn.value == "") {
                    return;
                }
        
                if (application.getSheet(sn.value) !== undefined) {
                    alert("You cannot create a sheet with that name!");
                    return;
                }
                 
                ARCSEditor.createSheet(sn.value); 
                ARCSEditor.Dialog.close();                 
            } },
            { selector: "#cancel", key: "onclick", value: ARCSEditor.Dialog.close } 
            
        ]
    });

    ARCSEditor.aboutDialog = new ARCSEditor.Dialog( { selector: "#about-dialog" });
    ARCSEditor.libraryDialog = new ARCSEditor.Dialog( { 
        selector: "#loadlibrary-dialog" 
    });
    
    ARCSEditor.controllerDialog = new ARCSEditor.Dialog( {
        selector: "#form-controller",
        replacements: [
            { selector: "#ok", key: "onclick", value: function() { 
                var cntrl = document.getElementById("cmp-controller");
                if (cntrl.value == "") {
                    return;
                }
                
                if (application.getComponent(cntrl.value) === undefined) {
                    alert("The component you have chosen do not exist!");
                    return;
                }
                
                ARCSEditor.setController(cntrl.value);
                ARCSEditor.Dialog.close(); 
                
            } },
            { selector: "#cancel", key: "onclick", value: ARCSEditor.Dialog.close },
            { selector: "#cmp-controller", run: ARCSEditor.populateComponents }
        ]
    });
    
    ARCSEditor.exportApplicationDialog = new ARCSEditor.Dialog( {
        selector: "#exportapplication-dialog",
        replacements: [
            { selector: "#exportzone", run: function(elt) {
                elt.innerHTML = JSON.stringify(
                    application.export(),null,'  '
                ).replace(/\n/g, "<br/>").replace(/ /g,"&nbsp;");
            }}
        ]        
    });
    
    ARCSEditor.importApplicationDialog = new ARCSEditor.Dialog( {
        selector: "#loadapplication-dialog",
    });
    
    

    new ARCSEditor.Template("nav").apply( 
        { selector: "#createsheet", key: "onclick", value: ARCSEditor.sheetCreationDialog.exec },
        { selector: "#about", key: "onclick", value: ARCSEditor.aboutDialog.exec },
        { selector: "#importlib", key: "onclick", value: ARCSEditor.libraryDialog.exec },
        { selector: "#setctrl", key: "onclick", value: ARCSEditor.controllerDialog.exec },
        { selector: "#exportapp", key: "onclick", value: ARCSEditor.exportApplicationDialog.exec },
        { selector: "#importapp", key: "onclick", value: ARCSEditor.importApplicationDialog.exec }
    );

    ARCSEditor.setController = function (ctrlName) {
        application.setController(ctrlName);
        document.getElementById("setctrl").innerHTML = "Set controller (<b>" + ctrlName + "</b>)";
    };
    
    ARCSEditor.addComponent = function (type, name, value) {
        var objectValue;
        if (name == "") {
            alert("Your component should have a name !");
            return;            
        }
        
        if (application.getComponent(name) !== undefined) {
            alert('Your application already have a component named "'+name+'"!');
            return;
        }

        // arcs application part
        if (value !== undefined) {
            if (value.trim() !== "") {
                try {
                    objectValue = JSON.parse(value);
                } catch (e) {
                    alert(value + " in add Component " + e.message);
                    return;
                }
            }
        }
        application.addComponent(name, type, objectValue);
        
        // editor part
        var createComponentDeletor = function (cName) {
            return function () {
                var line = document.querySelector("tr[data-cmp='"+cName+"']");
                line.parentNode.removeChild(line);
                application.removeComponent(cName);
            };
        };

        var createComponentEditor = function (name,type,value) {
            return function () { ARCSEditor.componentDialog.exec(name,type,value); };        
        };
        
        var setLineId = function(elt) { elt.dataset.cmp = name; };

        var table = document.querySelector("tbody#componentlist");
        
        var lineTemplate = new ARCSEditor.Template("#component-row");
        table.appendChild(
            lineTemplate.apply(
                { selector: "#name", key: "innerHTML", value: name },
                { selector: "#type", key: "innerHTML", value: type },
                { selector: "#value", key: "innerHTML", value: value },
                { selector: "#line", run: setLineId },
                { selector: ".edit", key: "onclick", value: createComponentEditor(name,type,value) },
                { selector: ".delete", key: "onclick", value: createComponentDeletor(name) }        
            )
        );
    };
    

    ARCSEditor.changeComponent = function (name, value) {        
        var objectValue ;
        if (name == "") {
            alert("Your component should have a name !");
            return;            
        }
        
        if (application.getComponent(name) === undefined) {
            alert('Your application should have a component named "'+name+'"!');
            return;
        }

        // arcs application part
        if (value !== undefined) {
            if (value.trim() !== "") {
                try {
                    objectValue = JSON.parse(value);
                } catch (e) {
                    alert(value + " in change Component" + e.message );
                    return;
                }
            }
        }
        application.setComponentValue(name, objectValue);
        
        // editor part
        document.querySelector("tr[data-cmp='"+name+"'] #value").innerHTML = value;
    };

    
    ARCSEditor.loadLibrary = function (element,cb) {
        var libName;
        if (typeof element === "string") {
            application.loadLibrary(element,cb);
            libName = element;
        } else {
            if (element.files === undefined) return;      
            if (element.files.length === 0) return;            
            application.loadLibrary({ url : URL.createObjectURL(element.files[0]), name: element.files[0].name },cb);
            libName = element.files[0].name;
        }
        
        var libraryList = document.getElementById("librarylist");
        var p = document.createElement('p');
        p.innerHTML = libName;
        libraryList.appendChild(p);
        
        ARCSEditor.Dialog.close();
    };
    
    
    ARCSEditor.importApplicationLevel2 = function (description) {
        var components = description.context.components;
        var prop, i, j, tab;
        
        for (prop in components) {
            if (components.hasOwnProperty(prop)) {
                ARCSEditor.addComponent(components[prop].type, prop, JSON.stringify(components[prop].value));
            }
        }
        
        ARCSEditor.setController(description.controller);
        
        for (prop in description.sheets) {
            if (description.sheets.hasOwnProperty(prop)) {
                ARCSEditor.createSheet(prop);
                tab = description.sheets[prop].preconnections;
                if (tab !== undefined) {
                    for (i = 0; i < tab.length; i++) {
                        ARCSEditor.addInvocation(prop, "preconnectionlist", tab[i]);
                    }
                }
                tab = description.sheets[prop].postconnections;
                if (tab !== undefined) {
                    for (i = 0; i < tab.length; i++) {
                        ARCSEditor.addInvocation(prop, "postconnectionlist", tab[i]);
                    }
                }
                tab = description.sheets[prop].cleanups;
                if (tab !== undefined) {
                    for (i = 0; i < tab.length; i++) {
                        ARCSEditor.addInvocation(prop, "cleanuplist", tab[i]);
                    }
                }
                tab = description.sheets[prop].connections;
                if (tab !== undefined) {
                    for (i = 0; i < tab.length; i++) {
                        ARCSEditor.addConnection(prop, tab[i]);
                    }
                }
            }
        }
    };
    
    ARCSEditor.importApplication = function (element) {
        if (element.files === undefined) return;
        if (element.files.length === 0) return;
        
        var descriptionData = new FileReader();
        
        descriptionData.readAsText(element.files[0]);
        descriptionData.onloadend = function (e) {
            // let's begin the fun part: we should load data.
            var description;
            
            try {
                description = JSON.parse(e.target.result);
            } catch (ex) {
                alert("Unable to read data file:" + ex.message);
                return ;
            }
            
            // now, this is fun, we will have to add all that we need.
            var prop, i, j=0;
            
            for (i = 0; i < description.context.libraries.length; i++) {
                // problem: libraries are asynchronously loaded.
                ARCSEditor.loadLibrary(description.context.libraries[i], function () {
                    j++;
                    if (j === description.context.libraries.length) {
                        ARCSEditor.importApplicationLevel2(description);
                    }                    
                });
            }
        };
           
        ARCSEditor.Dialog.close();
    };
    
    
    ARCSEditor.addInvocation = function (sheetName, type, invocation) {        
        var sheet = application.getSheet(sheetName);  
        
        if (sheet === undefined) {
            return;
        }
        
        // arcs application part 
        var invokeId;
        
        if (type === "preconnectionlist") { invokeId = sheet.addPreConnection(invocation); }
        if (type === "postconnectionlist") { invokeId = sheet.addPostConnection(invocation); }
        if (type === "cleanupList") { invokeId = sheet.addCleanup(invocation); }
        
        // editor part
        var table  = document.querySelector("div[data-sheet='"+sheetName+"'] ."+type);
        var setLineId = function(elt) { elt.dataset.invokeId = type + "-" + invokeId; }

        var createInvocationDeletor = function (root, id) {
            return function () {
                // table would be much better, instead of document
                console.log(root);
                var line = /*document*/root.querySelector("tr[data-invoke-id='"+type+"-"+id+"']");
                line.parentNode.removeChild(line);
                if (type === "preconnectionlist") { sheet.removePreConnection(id); }
                if (type === "postconnectionlist") { sheet.removePostConnection(id); }
                if (type === "cleanupList") { sheet.removeCleanup(id); }
            };
        };
        
        
        var createInvocationEditor = function (sheetName, invocationType, invocationObj) {
            return function () {
                ARCSEditor.invocationDialog.exec(sheetName, invocationType, invocationObj);
            };
        };

        var lineTemplate = new ARCSEditor.Template("#invocation-row");
        invocation.id = invokeId;
        table.appendChild(
            lineTemplate.apply(
                { selector: "#destination", key: "innerHTML", value: invocation.destination },
                { selector: "#slot", key: "innerHTML", value: invocation.slot },
                { selector: "#value", key: "innerHTML", value: escape(invocation.value) },
                { selector: "#line", run: setLineId }, 
                { selector: ".edit", key: "onclick", value: createInvocationEditor(sheetName, type, invocation) },
                { selector: ".delete", key: "onclick", value: createInvocationDeletor(table, invokeId) }        
            )
        );
    };
    
    ARCSEditor.changeInvocation = function (sheetName, invocationType, invocation) {
        var sheet = application.getSheet(sheetName);  
        var type = invocationType;
        var id = invocation.id;
        
        if (sheet === undefined) {
            return;
        }

        if (type === "preconnectionlist") { sheet.changePreConnection(invocation.id, invocation.value); }
        if (type === "postconnectionlist") { sheet.changePostConnection(invocation.id, invocation.value); }
        if (type === "cleanupList") { sheet.changeCleanup(invocation.id, invocation.value); }

        document.querySelector( "div[data-sheet='"+sheetName+"'] tr[data-invoke-id='"+type+"-"+id+"'] #value").innerHTML = invocation.value; 
    };
    
    ARCSEditor.addConnection = function (sheetName, connection) {
        var sheet = application.getSheet(sheetName);
        
        if (sheet === undefined) {
            return;
        }
        
        var linkId = sheet.addConnection(connection);
        var table = document.querySelector("div[data-sheet='"+sheetName+"'] .connectionlist");
        var setLineId = function(elt) { elt.dataset.linkId = linkId; }
        
        var createConnectionDeletor = function (root,id) {
            return function () {
                var line = root.querySelector("tr[data-link-id='"+id+"']");
                line.parentNode.removeChild(line);
                sheet.removeConnection(id); 
            };
        };
        
        var lineTemplate = new ARCSEditor.Template("#connection-row");
        table.appendChild(
            lineTemplate.apply(
                { selector: "#destination", key: "innerHTML", value: connection.destination },
                { selector: "#slot", key: "innerHTML", value: connection.slot },
                { selector: "#source", key: "innerHTML", value: connection.source },
                { selector: "#signal", key: "innerHTML", value: connection.signal },
                { selector: "#line", run: setLineId }, 
                { selector: ".delete", key: "onclick", value: createConnectionDeletor(table, linkId) }        
            )
        );
    };

    
    ARCSEditor.removeSheet = function (sName) {
        // arcs part.
        application.removeSheet(sName);
        
        // GUI part
        var sheetLi = document.querySelector("#sheettab li[data-content='"+sName+"']");
        var sheetDiv = document.querySelector("div[data-sheet='"+sName+"']");
        
        sheetLi.parentNode.removeChild(sheetLi);
        sheetDiv.parentNode.removeChild(sheetDiv);
    };

    
    ARCSEditor.clearSheettab = function() {
        var root = document.querySelector("#sheettab ul");
        var children = root.childNodes;
        var i, linkedElement;
            
        for ( i = 0; i < children.length; i++ ) {
        if (children[i].tagName !== undefined) {
            if (children[i].tagName.toLowerCase() === "li") {
                linkedElement = document.querySelector("div[data-sheet='"+children[i].dataset.content+"']");
                children[i].classList.remove("active");
                linkedElement.classList.remove("unmask");
                linkedElement.classList.add("mask");
            }
        }}
    };
    
    ARCSEditor.sheetTabSelect = function(elt) {
        var linkedElement = document.querySelector("div[data-sheet='"+elt.dataset.content+"']");
        elt.classList.add("active");
        linkedElement.classList.add("unmask");
        linkedElement.classList.remove("mask");
    };
    
    
    ARCSEditor.createSheet = function(snvalue) {
        var i;
        
        // modify the engine.        
        var sheet = new ARCS.Sheet();
        application.addSheet(snvalue, sheet);
        
        // modify the structure of the GUI
        var invocationDialogCreator = function(type) {
            return function () { 
                if (application.getComponentList().length > 0) {
                    ARCSEditor.invocationDialog.exec(snvalue, type); 
                } else {
                    alert("You must define some components!");
                }
            } 
        };
        
        var connectionDialogCreator = function () {
            if (application.getComponentList().length > 0) {
                ARCSEditor.connectionDialog.exec(snvalue);
            } else {
                alert("You must define some components!");
            }
        };
        
        var sheetDeletor = function (sname) { return function () { ARCSEditor.removeSheet(sname); } };
        
        /* let's create tabs */
        ARCSEditor.clearSheettab();
        var tab = document.querySelector("#sheettab ul");
        var li = document.createElement("li");
        var bt = document.createElement("button");
        bt.classList.add("delete");
        bt.innerHTML="&#10008;";
        bt.onclick = sheetDeletor(snvalue);
        li.appendChild(bt);
        li.classList.add("active");
        li.dataset.content = snvalue;
        li.appendChild(document.createTextNode(snvalue));
        tab.appendChild(li);
        li.onclick = function() { 
            ARCSEditor.clearSheettab();
            ARCSEditor.sheetTabSelect(li);            
        };
        
        var sheetTemplate = new ARCSEditor.Template('#template-sheet');
        var sheetsRoot = document.getElementById("sheets");
        sheetsRoot.appendChild(
            sheetTemplate.apply(
                { selector: "div", run: function (elt) { elt.dataset.sheet = snvalue; } },
                { selector: "div", key: "class", value: "unmask"},
                { selector: "#preconnadd", key: "onclick", value: invocationDialogCreator('preconnectionlist') },
                { selector: "#postconnadd", key: "onclick", value: invocationDialogCreator('postconnectionlist') },
                { selector: "#connadd", key: "onclick", value: connectionDialogCreator },
                { selector: "#cleanupadd", key: "onclick", value: invocationDialogCreator('cleanuplist') }
            )
        );
    };
    
});