/**
 * Bootstrap for the ARCS engine in a browser environment.
 * It relies on require.js to get the job done.
 * @file
 */

console.log("Bootstrapping ARCS...");

var baseUrl, appDescription, requireMarkup, xhr;

requireMarkup = document.querySelector('[data-main]');
if (requireMarkup !== undefined) {
        baseUrl = requireMarkup.dataset.baseUrl ;
        appDescription = requireMarkup.dataset.arcsapp || "arcsapp.json";    
}

// do not move these lines: xhr.open must be performed before require
// changes paths.
xhr = new XMLHttpRequest();
xhr.open('GET',appDescription,true);
xhr.overrideMimeType("application/json");
xhr.onerror = function (e) { 
    console.error("[ARCS] Failed to get app description (",appDescription,"):",e.target.status,e.message); 
};

require(['arcs'], function (ARCS) {
    //console.log(ARCS);    
    xhr.onreadystatechange = function() {
        if (xhr.readyState == 4 && (xhr.status == 200 || xhr.status == 0)) {
            try {
                console.log("ARCS application description loaded");
                var applicationObject = JSON.parse(xhr.responseText);
                if (baseUrl) {
                    require.config( { baseUrl: baseUrl });
                }
                var aap = new ARCS.Application();
                aap.import(applicationObject);
                console.log("Starting application...");
                aap.start();
            } catch (e) {
                console.error("[ARCS] Error while parsing JSON:",e); 
            }
        }
    };
    
    xhr.send();
});
