ARCSEditor.Template = function (selector) {
    var template = document.querySelector(selector);
    var lastClone; 
    
    this.apply = function () {
        var i, iStart, elt, replacements;
        
        if (template === undefined) {
            console.warn("[Template] "+ selector + " is undefined");
            return;
        }
        
        if (template.tagName.toLowerCase() === 'template') {
            lastClone = document.importNode(template.content, true);
        } else {
            lastClone = template;
        }
            
        
        if (arguments.length < 1) {
            return lastClone;
        }
        
        if (arguments[0] instanceof Array) {
            replacements = arguments[0];
        } else {
            replacements = arguments;
        }
        
        for (i = 0; i < replacements.length; i++) {
            if (replacements[i].selector !== undefined) {
                elt = lastClone.querySelector(replacements[i].selector);
                if (elt) {
                    if (typeof replacements[i].key === 'string' && 
                        replacements[i].value !== undefined) 
                    {            
                        elt[replacements[i].key] = replacements[i].value;
                    } else {
                        if (typeof replacements[i].run === 'function') {
                            replacements[i].run(elt);
                        }
                    }
                } else {
                    console.warn("[Template '"+ selector + "']: element '" + 
                        replacements[i].selector + "' not found."); 
                }
            }
        }
        
        return lastClone;
    };
};

