

/*
 * Dialog structure: 
 *  name: name or querySelector for the dialog template
 *  replacements : list of replacements made of querySelectors followed by 
 *    their replacement or actions: keys and values
 *    should also work for buttons
 */


ARCSEditor.Dialog = function( obj ) {
    var self = this;
    var overlay = ARCSEditor.Dialog.overlay;
    var panel = ARCSEditor.Dialog.panel;
    var template = new ARCSEditor.Template(obj.selector);
    
    this.exec = function () {
        var i, clone, keys, elt, replacements ; 
        overlay.style.visibility = "visible";
        
        if (typeof obj.init === "function" ) {
            obj.init.apply(obj,arguments);
        }
        
        if (obj.replacements === undefined) {
            panel.appendChild(template.apply());
        } else {
            panel.appendChild(template.apply(obj.replacements));
        }
    };
};

ARCSEditor.Dialog.overlay = document.getElementById("overlay");
ARCSEditor.Dialog.panel = document.querySelector("#overlay div");
ARCSEditor.Dialog.close = function () {
    ARCSEditor.Dialog.overlay.style.visibility = "hidden";
    ARCSEditor.Dialog.panel.innerHTML = "";        
};

