ARCS.Context = function( props ) { 
    for (p in props) {
        if (props.hasOwnProperty(p)) {
            this[p] = props[p];
        }
    }
};

ARCS.Context.prototype.getComponentList = function () {
    var list = Object.keys(this);
    var i;
        
    for (i = 0; i < list.length; i++) {
        if ( ! this.hasOwnProperty(list[i])) {
            list.splice(i--,1);
        }
    }
    return list;
};

ARCS.Context.prototype.getComponent = function (cName) {
    if (!this.hasOwnProperty(cName))
            return undefined;
    return this[cName].instance;
};

ARCS.Context.prototype.getComponentName = function (cmp) {
    var i, keys;
    keys = this.getComponentList();
           
    for(i = 0; i < keys.length; i++) {
        if (this[keys[i]].instance === cmp) {
                return keys[i];
        }
    }
        
    return undefined;
};

ARCS.Context.prototype.toJSON = function () {
    var res = {}, p;
    
    for (p in this) {
        if (this.hasOwnProperty(p)) {
            res[p] = { type: this[p].type, value: this[p].value };
        }
    }
    return res;
};

