/******************************************************************************
 * Connection implementation
 * ***************************************************************************/
/** 
 * Defines a connection between two components
 * @param source {object} component at the source
 * @param signal {string} name of the signal emitting data
 * @param destination {object} component at the destination 
 * @param slot {string} name of the signal receiving data
 * @class
 */
ARCS.Connection = function (source, signal, destination, slot) {
    /**
     * Connects two components as described in this object
     */
    this.connect = function () {
        ARCS.Component.connect(source, signal, destination, slot);
    };
    /**
     * Disconnects a signal/slot connection between the two components
     * described in this object.
     */
    this.disconnect = function () {
        ARCS.Component.disconnect(source, signal, destination, slot);
    };
    
    this.getSource = function() {
        return source; 
    };
    
    this.getDestination = function () {
        return destination;
    };
    
    this.getSlot = function ()  {
        return slot;
    };
    
    this.getSignal = function () {
        return signal;
    };   
};
/**
 * Helper function that casts a connection from a description 
 * @param obj {object} a raw description of the connection
 * @param context {object} the context in which this connection takes place.
 * @return a connection
 */
ARCS.Connection.cast = function (obj, context) {
    return new ARCS.Connection(context[obj.source].instance, obj.signal,
                                context[obj.destination].instance, obj.slot);
};
