arcs_module(
    function(ARCS) {
        var Notificator;

        Notificator = ARCS.Component.create(
            function () {
                var notificationZone;
                var self=this;
                
                this.setNotificationZone = function( id ) {
                    notificationZone = document.getElementById(id);
                };
                
                this.display = function (message, timeout) {
                    if (notificationZone === undefined) {
                        return;
                    }
                    
                    notificationZone.innerHTML = message;
                    notificationZone.style.display = "block";

                    if (timeout !== undefined) {
                        setTimeout(function () { self.hide();}, timeout);
                    }
                    
                };
                
                this.hide = function () {
                    if (notificationZone === undefined) {
                        return; 
                    }
                    notificationZone.style.display = "none";
                };

            },
            ["setNotificationZone", "display", "hide"],
            []
        );

        return { Notificator: Notificator};
    }
);