arcs_module(
    function(ARCS, SURF, SVD, POS) {
        var DiceDetector, DiceFace, recoverImageData;
        var temporaryCanvas; 
        
        var recoverImageData = function(imageId) {
            var canvas = temporaryCanvas; 
            var image = document.getElementById(imageId);
            if ( ! (canvas && image) ) {
                console.error('Cannot extract image data',canvas, image);
                return ;
            }
            var style = window.getComputedStyle(image);
            canvas.width = image.width; //parseInt(style.width);
            canvas.height = image.height; //parseInt(style.height);
            
            var context = canvas.getContext("2d");
            context.drawImage(image, 0,0);
            
            console.log(canvas.width, canvas.height);

            return context.getImageData(0,0,canvas.width,canvas.height);
        };
        
        /**
         * Dice face description
         * @typedef {Object} DiceFaceDescription
         * @property {number[]} center - coordinates of the face center.
         * @property {number[]} xaxis  - coordinates of the x direction for the image.
         * @property {number[]} yaxis  - coordinates of the y direction for the image.
         * @property {number} width - width of the image in unit length.
         * @property {number} height - height of the image in unit length.
         * @property {string} imageId - ID of the HTML element containing the image
         */
        
        
        /**
         * @class DiceFace
         * @classdescr Structure dfinissant une face du cube.
         * Chaque face a une position et une orientation dans l'espace du cube,
         * ainsi qu'une image particulire illustrant la face.
         */
        

        /**
         * @param descr {DiceFaceDescription} a structured object describing each dice face.
         * @constructor DiceFace
         */        
        var DiceFace = function(descr) {
            var center, xaxis, yaxis, width, height, imageData, keyPoints ;
            
            center = descr.center;
            xaxis = descr.xaxis;
            yaxis = descr.yaxis;
            width = descr.width;
            height = descr.height;
            //put some code here to load image and detect keyPoints
            imageData = recoverImageData(descr.imageId);
            var grayImage = SURF.grayImage(imageData);                        
            this.keyPoints = SURF.surfDetDes(grayImage, 3,4,3,0.01);
            
            
            this.get3DCounterpart = function(p2D) {
                 
                
            };
            
        };
        
                               
        DiceDetector = ARCS.Component.create(
            function(initData) {
                var focalLength; 
                var diceFaces = [];
                var i;
                if (initData.faces === undefined) { 
                    console.error("Description for dice faces is not well formed.");
                }
                if (initData.faces.length < 6) {
                    console.error("A dice must have 6 faces.");
                    return;
                }
                
                temporaryCanvas = document.getElementById(initData.canvas);
                                
                for (i = 0 ; i < 6; i++ ) {
                    diceFaces[i] = new DiceFace(initData.faces[i]);
                }
                
                this.detect = function(image) {
                    
                };
                
                this.setFocal = function( focalLength) {
                    
                };
                
                
//                 
                
                
            },
            ['detect','setFocal'],
            ['sendPose','sendMatchedImage','sendImage']

            
            
        );
        
        return { DiceDetector : DiceDetector };
    },
    [ 
        {name:"deps/surf/surf", exports:"SURF"},
        {name:"deps/pose/posit",exports:"POS"},
        {name:"deps/pose/svd",exports:"SVD"}
    ]    
);