/*
  name: tools/editor/stringlistvalidator.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include "stringlistvalidator.h"


StringListValidator::StringListValidator(QStringList lst, QObject *parent) :
    QValidator(parent)

{
    strings = lst;
}


QValidator::State StringListValidator::validate(QString &str, int &) const
{
    if (str.isEmpty())
        return Intermediate;
    if (strings.contains(str))
        return Acceptable;

    if (strings.indexOf(QRegExp(str+"*",Qt::CaseSensitive,QRegExp::Wildcard)) >= 0 )
        return Intermediate;

    return Invalid;
}
