(: preambule :)
<application mode="gui">
<context>

<libraries>
{ doc($file)/application/libraries/library/<library path="{@name}"/>}
</libraries>

<components>
{doc($file)/application/objects/object[@classname]/<component id="{@id}" type="{@classname}"/>}
{doc($file)/application/objects/object[@file]/<component id="{@id}" type="Composite" file="{@file}"/>}
<component id="__statemachine__" type="StateMachine">

<statemachine>
{doc($file)/application/statemachine/<first name="{@initial}"/>}
{doc($file)/application/statemachine/<last name="{@terminal}"/>}
<transitions>
{doc($file)/application/statemachine/transition/<transition source="{@stepA}" destination="{@stepB}" token="{@token}"/>}
</transitions>
</statemachine>

</component>            
</components>


<constants>
{ doc($file)/application/defines/define/<constant id="{@id}" type="{@type}">{data(@value)}</constant>}
</constants>

</context>


<processes>
<process controller="__statemachine__">
{
    doc($file)/application/sheets/sheet/<sheet id="{@id}">
    <preconnections>
    { preconnection/init[@type != "object"]/<invoke destination="{@object}" slot="{@slot}" type="{@type}">{data(@value)}</invoke> }
    { preconnection/init[@type = "object"]/<invoke destination="{@object}" slot="{@slot}" type="component">{data(@value)}</invoke> }
    </preconnections>
    <connections>
    { connection/wire/<link source="{@objsource}" signal="{@signal}" destination="{@objdest}" slot="{@slot}"/>}
    { tokensender/<link source="{@object}" signal="sendToken(QString)" destination="__statemachine__" slot="setToken(QString)"/>}
    </connections>
    <postconnections>
    { postconnection/init[@type != "object"]/<invoke destination="{@object}" slot="{@slot}" type="{@type}">{data(@value)}</invoke> }
    { postconnection/init[@type = "object"]/<invoke destination="{@object}" slot="{@slot}" type="component">{data(@value)}</invoke> }
    </postconnections>
    </sheet>
}
        </process>
    </processes>
</application>
