/*
  name: sample/sample.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include "sample.h"
#include <iostream>


#ifdef WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif

void Loop::setIterations(int n)
{
     for (int i = 0; i < n ; i++)
     {
	std::cout << "[Loop] Emitting iteration " << i << std::endl;
	  emit newIteration(i);
     }
     emit sendToken("end");
}


void DisplayInt::display(int i)
{
     std::cout << "[DInt] Received integer " << i << std::endl;
}


void DisplayInt::display(intArray ia)
{
    std::cout << "[DInt] Recieved integer array " << std::endl;
    for (int i = 0 ; i < ia.getSize() ; i++)
    {
        std::cout << "\t" << ia[i] << std::endl;
    }


}

void StackExploder::tic()
{
    calls++;
    if (calls % 1000 == 0)
        std::cout << "[Stack] " << calls << " calls performed."  << std::endl;
    emit toc();
}


ComponentNester::ComponentNester(QObject* parent) : QObject(parent)
{
    nestedComponent = 0;
}

void ComponentNester::setComponent(QObject* cmp)
{
    std::cout << "[NCmp] Nesting component" << std::endl;
    Loop* loop = dynamic_cast<Loop*>(cmp);

    if (loop == 0)
        return ;

    nestedComponent = loop;

    std::cout << "[NCmp] Nesting succeeded" << std::endl;
}

void ComponentNester::setIterations(int n)
{
    std::cout << "[NCmp] Nesting iteration calls" << std::endl;
    if (nestedComponent == 0)
        return;

    nestedComponent->setIterations(n);
    std::cout << "[NCmp] Iterations transmitted" << std::endl;
}

void Sleeper::setSeconds(int n)
{
    std::cout << "[Slp] I will sleep " << n << " seconds." << std::endl;
    for (int i=0; i < n ; i++)
    {
        std::cout << "[Slp] " << qPrintable(text) << " is sleeping " 
            << i << std::endl;
#ifdef WIN32
        Sleep(1000);
#else
        sleep(1);
#endif


    }
    emit sendToken("end");
}
