/*
  name: lib/arcsnativefamily.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include <arcs/arcsfactory.h>
#include <QtDebug>

QString ARCSNativeFamily::name() const
{
     return QString("native");
}


bool ARCSNativeFamily::isInternal() const
{
     return true;
}


ARCSNativeFamily::ARCSNativeFamily ()
{

}


ARCSNativeFamily::~ARCSNativeFamily()
{

}


ARCSAbstractComponent* ARCSNativeFamily::instanciate(QString type)
{
     ARCSNativeComponent* acf = factories.value(type, 0);
     if (acf == 0)
	  return 0;

     ARCSNativeComponent* anc = acf->genuineClone();
     if (anc == 0)
         return 0;

     anc->setType(type);
     anc->setFamily(acf->getFamily());
     return anc;
}


bool ARCSNativeFamily::addFactory(QString s, ARCSAbstractComponent* whatever)
{
     ARCSNativeComponent* acf = dynamic_cast<ARCSNativeComponent*> (whatever);

     if (acf == 0)
       return false;
     
     if (factories.contains(s))
     { 
	  qCritical() << "[]" ;
	  return false;
     }

     factories.insert(s, acf);
     return true;
}


void ARCSNativeFamily::removeFactory(QString s)
{
     factories.remove(s);
}


void ARCSNativeFamily::destroy(ARCSAbstractComponent* aac)
{
     ARCSNativeComponent* anc = dynamic_cast<ARCSNativeComponent*> (aac);

     if (anc != 0)
	  delete anc;
}
