/*
  name: include/arcs/arcsnativecomponent.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSNATIVECOMPONENT_H__
#define __ARCSNATIVECOMPONENT_H__

#include <arcs/arcsabstractcomponent.h>

#include <QMetaType>
#include <QMetaMethod>
Q_DECLARE_METATYPE(QObject*)
#include <iostream>

class QStringList;

/*! \brief Component representation of ARCS Native components
 * \author Jean-Yves Didier
 * \date November, 2008
 * \ingroup lib
 */
class DLL_POINT ARCSNativeComponent : public ARCSAbstractComponent
{
public:
     ARCSNativeComponent() ;
     virtual ~ARCSNativeComponent();

     virtual QStringList getSlots();
     virtual QStringList getSignals();
     virtual QString toString();
     virtual bool parseString(QString );
     virtual QVariant getGenuineComponentInstance() { QVariant var; var.setValue(realObject); return var; }
     //! Kage bunshin no jutsu !
     /*! This methods intends to clone a native component.
      * It calls genuineClone() to perform the actual cloning of subclasses and
      * then take care of meta-properties like: type, family and so on.
      */
     virtual ARCSNativeComponent* genuineClone() =0;


protected:
     virtual void getProxySlot(QString slot, ObjectList & obj, QStringList & proxySlot) 
       {
	 obj << realObject ; proxySlot << slot; 
       }
     virtual void getProxySignal(QString signal, ObjectList & obj, QStringList & proxySignal) { obj << realObject ; proxySignal << signal; }
     virtual bool genuineInstanciate();
     virtual void genuineDestroy();


     virtual QObject* createObject(QObject* parent)=0;
     virtual void destroyObject(QObject* obj) = 0;
     virtual QMetaObject getDescription() = 0;
     virtual QString getName() { return QString( getDescription().className()); } 

private:
     QObject* realObject;
     static QObject* father;
};




#endif //__ARCSNATIVECOMPONENT_H__
