/*
  name: include/arcs/arcslibmanager.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSLIBMANAGER_H__
#define __ARCSLIBMANAGER_H__

#include <arcs/arcslibtoolkit.h>
#include <QLibrary>

//! This class is a dynamic library manager.
/*! Objects instanciated from this class can dynamically load plugins for the ARCS engine.
  * They have multiple roles:
  * <ul>
  * <li>They load natives components;</li>
  * <li>They load component families;</li>
  * <li>They load new types;</li>
  * </ul>
  * A reference counter is also embedded. It allows to unload the library if needed.
  * \author Jean-Yves Didier
  * \date November, the 20th, 2008
  * \ingroup lib
  */


class ARCSLibManager 
{
public:
     ARCSLibManager(QString libname);
     ~ARCSLibManager();

     /*! Returns the native component map from the library */
     ARCSComponentMap getComponentMap() { return components;}
     /*! Returns the component families mapped in this library */
     ARCSFamilyMap getFamilyMap() { return families; }
     /*! Returns the types mapped in this library */
     ARCSTypeMap getTypeMap() { return types;}

     /*! Increment reference counter */
     void ref()   { refcount++; }
     /*! Decrement reference counter */
     void unref() { if (refcount > 0) refcount--; }
     /*! Checks wether the library is referenced or not. */
     bool isRef() { return refcount > 0; }
     /*! Checks wether the library is loaded or not. */
     bool isLoaded() { return loaded; }
     /*! Returns the textual error */
     QString getError() { return lib.errorString(); }
     /*! Returns the name of the library */
     QString getName() { return name;}


private:
     typedef void (*LibWrapper)(ARCSComponentMap* cmap, ARCSFamilyMap* fmap, ARCSTypeMap* type); 

     LibWrapper libraryRegister ;
     LibWrapper libraryUnregister;

     QLibrary lib;
     ARCSComponentMap components;
     ARCSFamilyMap families ;
     ARCSTypeMap types;
     bool loaded;

     int refcount;
     QString name;

};



#endif //__ARCSLIBMANAGER_H__
