/*
  name: include/arcs/arcsinternalfamily.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSINTERNALFAMILY_H__
#define __ARCSINTERNALFAMILY_H__

#include <arcs/arcsabstractfamily.h>


//! This class represents the family that describes several internal component types
/*!
 * \author Jean-Yves Didier
 * \ingroup lib
 * \date May, the 5th, 2009
 */
class ARCSInternalFamily : public ARCSAbstractFamily
{
     virtual ~ARCSInternalFamily() {}
     virtual QStringList factoryList() ;
     virtual bool addFactory(QString , ARCSAbstractComponent* ) ;
     virtual void removeFactory(QString ) ;
     virtual ARCSAbstractComponent* instanciate(QString type) ;
     virtual void destroy(ARCSAbstractComponent* component);
     virtual QString name() const;
     virtual bool isInternal() const { return true; }
};

#endif // __ARCSINTERNALFAMILY_H__
