/*
  name: include/arcs/arcscompositecomponent.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSCOMPOSITECOMPONENT_H__
#define __ARCSCOMPOSITECOMPONENT_H__

#include <arcs/arcssheet.h>
#include <arcs/arcsmethod.h>
#include <arcs/arcsdll.h>

//! Class defining a composite component i.e. a component made of components.
/*! This kind of component stores its own context as well as a sheet structure
  * and a basic interface description.
  * One can consider the design pattern composite as a model of this implementation.
 * \author Jean-Yves Didier
 * \date December, the 12th, 2008
 * \ingroup lib
 */
class DLL_POINT ARCSCompositeComponent : public ARCSAbstractComponent
{
public:
     ARCSCompositeComponent();
     ~ARCSCompositeComponent();

     virtual QStringList getSlots();

     virtual QStringList getSignals();


     virtual QString toString();
     virtual bool parseString(QString s);

     virtual bool loadFile(QString fn);
     virtual bool saveFile(QString fn);

          //! Sets the sheet to use as an internal description of embedded components.
     void setSheet(ARCSSheet ref)
     {
	  sheet = ref;
	  context = *(sheet.getContext());
     }

     //! Returns the internal structure of this composite component described as a sheet.
     ARCSSheet* getSheet() { return &sheet; }

     //! Returns the internal context of the composite component.
     ARCSContext getContext() { return context; }

     //! Adds a wrapper to an internal component and its signal
     /*! \param proxy name of the external interface entry
      * \param id internal component's id
      * \param signal internal component's signal
      */
     bool addProxySignal(QString proxy, QString id, QString signal)
     {
	  return addMethod(proxySignals, proxy,id, signal);
     }

     //! Adds a wrapper to an internal component and its slot
     /*! \param proxy name of the external interface entry
      * \param id internal component's id
      * \param signal internal component's slot
      */
     bool addProxySlot(QString proxy, QString id, QString slot)
     {
	  return addMethod(proxySlots, proxy, id, slot);
     }


     /*! Returns lists of proxy slots */
     void getProxySlots(QStringList& proxies, QStringList& objects, QStringList& slotNames)
       {
	 getProxyMethods(proxySlots, proxies, objects, slotNames);
       }

     /*! Returns lists of proxy signals */
     void getProxySignals(QStringList& proxies, QStringList& objects, QStringList& signalNames)
       {
	 getProxyMethods(proxySignals, proxies, objects, signalNames);
       }


protected:
     virtual void getProxySlot(QString slot, ObjectList & obj, QStringList & proxySlot);
     virtual void getProxySignal(QString signal, ObjectList & obj, QStringList & proxySignal);
     virtual bool genuineInstanciate() ;
     virtual void genuineDestroy();

private:
     bool addMethod(QMap<QString, ARCSMethod> & list, QString proxy, QString id, QString method);
     void getProxyMethods(QMap<QString, ARCSMethod> & list, QStringList & proxies, QStringList & objects, QStringList& methodNames);

     ARCSContext context; 
     ARCSSheet sheet;
     QMap<QString, ARCSMethod> proxySlots;
     QMap<QString, ARCSMethod> proxySignals;
};



#endif //__ARCSCOMPOSITECOMPONENT_H__
