/*
  name: include/arcs/arcsapplicationobject.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSAPPLICATIONOBJECT_H__
#define __ARCSAPPLICATIONOBJECT_H__

#include <arcs/arcscontext.h>

//! Application objects are used to implement specific interfaces when the application needs to be embedded.
/*!
 * \author Jean-Yves Didier
 * \date January, the 9th, 2009
 * \ingroup lib
 */
class ARCSApplicationObject : public QObject
{
Q_OBJECT

     public:
     ARCSApplicationObject(QObject* parent = 0);
     
     public slots:

     //! This slot, provided with a component name, instanciates a component.
     /*! 
      * The purpose of this slot is to maintain the compatibility with the previous version
      * of ARCS. It manages the life cycle of components.
      */
     void instanciate(QString name);

     //! This slot, provided with a component name, destroys a component.
     /*!
      * The purpose of this slot is to maintain the compatibility with the previous version
      * of ARCS. It manages the life cycle of components.
      */     
     void destroy(QString name);

     
};

#endif //__ARCSAPPLICATIONOBJECT_H__
