/*
  name: tools/wizard/arcsenginecontext.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSENGINECONTEXT_H__
#define __ARCSENGINECONTEXT_H__

#include <QHash>
#include <QStringList>
#include <iostream>

class ARCSEngineContext
{
public :
        ARCSEngineContext() {}

int getConstantNumber()
{
    return constants.count();
}

QStringList getConstants() { return constants.keys() ;}

void clear() { constants.clear(); }


bool createConstant(QString id, QString type, QString value) {
     if (constants.contains(id))
          return false;
     constants.insert(id,Store(type,value));
     return true;
}
bool modifyConstant(QString id, QString value) {
     if (!constants.contains(id))
          return false;
     constants[id].value = value;
     return true;
}
bool compareConstant(QString id,QString value); /* {
     if (!constants.contains(id))
          return false;


     //return (constants.value(id) == value) ;
     return true;
}*/
QString getConstantValue(QString id) {
     if (!constants.contains(id))
          return QString::null;
     return constants[id].value;
}

QString getConstantType(QString id) {
     if (!constants.contains(id))
          return QString::null;
     return constants[id].type;
}

/*ARCSEngineContext operator^(const ARCSEngineContext& aec);
ARCSEngineContext operator|(const ARCSEngineContext& aec);*/
ARCSEngineContext merge(ARCSEngineContext aec);
ARCSEngineContext diff(ARCSEngineContext aec);



private:
struct Store{
     QString type ;
     QString value ;
     Store(QString t, QString v) { value=v; type=t; }
     Store() { type=QString::null; value=QString::null; }
};
     QHash<QString,Store> constants;
};


#endif // __ARCSENGINECONTEXT_H__
