/*
  name: tools/porting/main.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include <QCoreApplication>
#include <QStringList>
#include <QXmlQuery>
#include <QDomDocument>
#include <QTextStream>
#include <QFile>
#include <iostream>

QStringList retrieveQt4Headers(QString qin)
{
    QStringList res;
    QXmlQuery query;
    query.setQuery("doc(\""+qin+"\")/Rules/item[@Type=\"qt4Header\"]/string(data(node()))");
    query.evaluateTo(&res);
    return res;
}

QStringList retrieveQt3Headers(QString qin)
{
    QStringList res;
    QXmlQuery query;
    query.setQuery("doc(\""+qin+"\")/Rules/item[@Type=\"qt3Header\"]/string(data(node()))");
    query.evaluateTo(&res);
    return res;
}

void createNewQ3Porting(QString qin,QString qout)
{

    QDomDocument doc;
    QFile file(qin);
    if (!file.open(QIODevice::ReadOnly))
    {
        std::cerr << "Could not open " << qPrintable(qin) << std::endl; 
        return ;
    }
    if (!doc.setContent(&file)) 
    {
        std::cerr << "Could not parse " << qPrintable(qin) << std::endl;
        file.close();
        return ;
    }

    // parcours du fichier XML
    QDomNodeList items = doc.elementsByTagName("item");
    QStringList headers4 = retrieveQt4Headers(qin);
    QStringList headers3 = retrieveQt3Headers(qin);

    // premire tape : substitution bte et mchante des headers 3 dj renomms en headers 4
    for(int i=0; i < items.count() ; i++)
    {
        QDomElement item = items.at(i).toElement();
        if (item.hasAttribute("Type"))
        {
            if (item.attribute("Type") == "RenamedHeader")
            {
                QDomNodeList qt4s = item.childNodes();
                for (int j=0; j< qt4s.count() ; j++)
                {
                    if (qt4s.at(j).nodeName() == "Qt4")
                    {
                        QString qt3header = qt4s.at(j).lastChild().nodeValue();
                        QString qt4header = QString(qt3header).replace(".h","");
                        for (int k=0; k< headers4.count(); k++)
                        {
                            if (headers4[k].toLower() == qt4header)
                            {
                                qt4s.at(j).lastChild().setNodeValue(headers4[k]);
                                //headers3.removeAll(qt3header);
                                std::cout << "Remove qt3 header " << qPrintable(qt3header) << std::endl;
                                std::cout << qPrintable(headers4[k]) << std::endl;
                            }
                        }
                    }
                }
            }
        }
    }

    // deuxime tape : substitution des headers 3 oublis
    
    // a : retrouver le dcompte (s'il existe)
    QDomNodeList counts = doc.elementsByTagName("Count");
    QDomElement count;
    int rulesCount = 0;
    if (counts.count() > 0)
    {
        count = counts.at(0).toElement();
        rulesCount = count.lastChild().nodeValue().toInt();
    }
    // b : traiter la liste des substitutions  raliser
    int substitutions= 0;


    for (int i=0; i < headers3.count() ; i++)
    {
        for (int j=0; j < headers4.count() ; j++)
        {
            QString testString=QString(headers3[i]).replace(".h","");
            if (headers4[j].toLower() == testString)
            {
                substitutions++;
                QDomElement elt = doc.createElement("Item");
                elt.setAttribute("Type","RenamedHeader");
                QDomElement qt3 = doc.createElement("Qt3");
                QDomElement qt4 = doc.createElement("Qt4");
                qt4.appendChild(doc.createTextNode(headers4[j]));
                qt3.appendChild(doc.createTextNode(headers3[i]));
                elt.appendChild(qt4);
                elt.appendChild(qt3);
                doc.documentElement().appendChild(elt);
                std::cout << qPrintable(headers3[i]) << " --> " << qPrintable(headers4[j]) << std::endl; 
            }
        }        
    }

    if (rulesCount > 0)
    {
        count.lastChild().setNodeValue(QString::number(rulesCount + substitutions));
    }


    QFile out(qout);
    if (!out.open(QIODevice::WriteOnly))
    {
        std::cerr << "Could not open " << qPrintable(qout) << std::endl;
        return ;
    }
    QTextStream ts(&out);
    doc.save(ts,4);
    out.close();
}

int main(int argc,char* argv[])
{
    QCoreApplication app(argc,argv);
    
    createNewQ3Porting("q3porting.xml","q3porting2.xml");

    return 0;
}
