/*
  name: tools/libmaker/arcslibmakerparser.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSLIBMAKERPARSER_H__
#define __ARCSLIBMAKERPARSER_H__

#include <QStringList>
#include <QDomDocument>
#include <QList>


class ARCSTypeWrapper
{
public:
     ARCSTypeWrapper(QString n=QString::null, QString w=QString::null)
     {
          setWrapper(w);
          setName(n);
     }

     ARCSTypeWrapper(const ARCSTypeWrapper& t)
     {
          wrapper = t.wrapper;
          name = t.name;
     }

     QString getName() { return name; }
     void setName(QString n) { name = n; }
     QString getWrapper() { return wrapper; }
     void setWrapper(QString w) { wrapper = w; }


     bool operator==(const ARCSTypeWrapper& t)
     {
          return ((wrapper == t.wrapper) && (name == t.name)) ;

     }

private:
     QString name;
     QString wrapper;
};


class ARCSLibMakerParser
{
public:
     ARCSLibMakerParser();
     
     void clear();

     void setFileName(QString s) { fileName = s ; }
     bool parseFile();
     bool writeFile();

     void addComponent(QString name) { components.push_back(name); }
     void addHeader(QString name) { headers.push_back(name); }
     void addType(QString name) { types.push_back(name); }
     void addFamily(QString name) { families.push_back(name); }

     void removeComponent(QString name) { components.removeAll(name); }
     void removeHeader(QString name) { headers.removeAll(name); }
     void removeType(QString name) { types.removeAll(name); }
     void removeFamily(QString name) { families.removeAll(name); }

     QStringList getHeaders() { return headers; }
     QStringList getComponents() { return components; }
     QList<ARCSTypeWrapper> getTypes() { return types; }
     QStringList getFamilies() { return families; }

private:
     void parseSection(QString secname, QStringList & strlist);
     void parseHeaders() { parseSection("header",headers); }
     void parseComponents() { parseSection("component", components); }
     void parseTypes(); // { parseSection("type", types); }
     void parseFamilies() { parseSection("family", families); }

     QStringList headers;
     QStringList components;
     QList<ARCSTypeWrapper> types;
     QStringList families;

     QString fileName;

     QDomDocument doc;
};

#endif //__ARCSLIBMAKERPARSER_H__
