/*
  name: tools/editor/sheetview.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __SHEETVIEW_H__
#define __SHEETVIEW_H__

//#include <QWidget>
#include <QGraphicsView>
#include <QAction>
#include <arcs/arcssheet.h>
#include "graphicsinvocationitem.h"

class QAction;
class QToolBar ;
class GraphicsComponentItem;
class QGraphicsRectItem;

class SheetView : public QGraphicsView
{
Q_OBJECT

public:
    explicit SheetView(ARCSSheet& s, QWidget* parent=0);
    virtual ~SheetView();

    void addComponent(QPoint p, QString name);
    ARCSSheet& getSheet() { return sheet; }

    void sendWidget(QWidget* w) {
        w->setProperty("appId",property("appId"));
        emit addWidget(w);
    }

protected:
    virtual void dragEnterEvent(QDragEnterEvent *event) ;
    virtual void dragMoveEvent(QDragMoveEvent *event) ;
    virtual void dropEvent(QDropEvent *event);

    virtual void mousePressEvent(QMouseEvent *event);
    virtual void mouseReleaseEvent(QMouseEvent *event);
    virtual void mouseMoveEvent(QMouseEvent *event);

    virtual void contextMenuEvent(QContextMenuEvent *event);


public slots:
    void updateSheet();
    void copy();
    void paste();
    void deleteSelection();
    void clearSelection();
    void selectAll();
    void orderInvocations();
    void orderConnections();

signals:
    void addWidget(QWidget*);
    void requestApplicationUpdate();

private:
    void clearScene();

    GraphicsComponentItem* findComponentByName(QString name);
    void layoutSheet();
    void layoutInvocations(GraphicsInvocationItem::InvocationType invocationType,QStringList destinations,QStringList slotList,QStringList typeList, QStringList valueList );


    //QToolBar* toolBar;
    ARCSSheet& sheet;
    QStringList componentList;
    QGraphicsRectItem* rectSelection;

    QAction* actionSelectAll;
    QAction* actionCopy;
    QAction* actionPaste;
    QAction* actionDelete;

    QAction* actionOrderInvocations;
    QAction* actionOrderConnections;

};


#endif // __SHEETVIEW_H__
