/*
  name: tools/editor/portdialog.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include "portdialog.h"

#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include <QListWidget>
#include <QCompleter>
#include <QPushButton>

#include <QMessageBox>

#include <iostream>

PortDialog::PortDialog(ARCSAbstractComponent *aac, bool slt, QWidget *parent) : QDialog(parent)
{

    QVBoxLayout* vlayout;
    setLayout(vlayout = new QVBoxLayout(this));

    QString portTypeName ;

    if (slt)
    {
        portList = aac->getSlots();
        portTypeName = "slot";
    }
    else
    {
        portList = aac->getSignals();
        portTypeName = "signal";
    }

    layout()->addWidget(new QLabel("Please pick a "+portTypeName + " name."));
    portNameEdit = new QLineEdit(this);
    portNameEdit->setCompleter(new QCompleter(portList));
    layout()->addWidget(portNameEdit);

    QListWidget* portListView = new QListWidget(this);
    portListView->insertItems(0,portList);

    layout()->addWidget(portListView);
    connect(portListView,SIGNAL(currentTextChanged(QString)),portNameEdit,SLOT(setText(QString)));

    QHBoxLayout* hlayout = new QHBoxLayout(this);
//    std::cout << "kaboom" <<std::endl;

    vlayout->addLayout(hlayout);
    QPushButton* ok = new QPushButton("Ok",this);
    QPushButton* cancel = new QPushButton("Cancel",this);

    connect(ok,SIGNAL(clicked()),SLOT(accept()));
    connect(cancel,SIGNAL(clicked()),SLOT(reject()));


    hlayout->addWidget(ok);
    hlayout->addWidget(cancel);
}


void PortDialog::accept()
{
    if (portList.contains(portNameEdit->text()))
    {
        QDialog::accept();
        return ;
    }

    QMessageBox::critical(this,"Invalid method name","Please provide a valid method name");
}
