/*
  name: tools/editor/invocationdialog.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __INVOCATIONDIALOG_H__
#define __INVOCATIONDIALOG_H__

#include <QDialog>
#include <QComboBox>
#include <QTextEdit>
#include <QButtonGroup>
#include <arcs/arcsinit.h>

//! \todo the line below introduces a dependency for just an enum !
#include "graphicsinvocationitem.h"

class QRadioButton;

class InvocationDialog : public QDialog
{
    Q_OBJECT
public:
    explicit InvocationDialog(QString portName,QWidget *parent = 0);
    
    GraphicsInvocationItem::InvocationType getInvocationType() {
        return static_cast<GraphicsInvocationItem::InvocationType>(bgType->checkedId());
    }
    QString getTypeName() { return cbType->currentText(); }
    QString getValue() { return teValue->toPlainText(); }

public slots:
    virtual void accept();

private:
    void prepareDialog();

    GraphicsInvocationItem::InvocationType type;
    QComboBox* cbType;
    QTextEdit* teValue;
    QButtonGroup* bgType;

};

#endif // __INVOCATIONDIALOG_H__
