/*
  name: tools/editor/invocationdialog.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include "invocationdialog.h"
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QLabel>

#include <QRadioButton>
#include <QButtonGroup>
#include <QPushButton>

#include <iostream>

#include <arcs/arcsfactory.h>
#include "stringlistvalidator.h"
#include <QMessageBox>

InvocationDialog::InvocationDialog(QString portName, QWidget *parent) :
    QDialog(parent)
{
    prepareDialog();

    QString paramLiteralType = portName.section('(',1,1).section(')',0,0).section(',',0,0);


    QString actualType = ARCSFactory::getInstance()->getInternalType(paramLiteralType);

    if (actualType.isEmpty())
        cbType->setCurrentIndex(cbType->findText("void"));
    else
        cbType->setCurrentIndex(cbType->findText(actualType));


}


void InvocationDialog::prepareDialog()
{
    QVBoxLayout* vlayout;
    setLayout(vlayout = new QVBoxLayout(this));

    layout()->addWidget(new QLabel("Select an invocation type"));
    layout()->addWidget(cbType = new QComboBox(this));
    layout()->addWidget(new QLabel("Invoke at:"));

    QRadioButton* rbPre;
    QRadioButton* rbPost;
    QRadioButton* rbCleanup;

    bgType = new QButtonGroup(this);
    layout()->addWidget(rbPre = new QRadioButton("Pre-connection",this));
    layout()->addWidget(rbPost = new QRadioButton("Post-connection",this));
    layout()->addWidget(rbCleanup = new QRadioButton("Cleanup stage",this));

    bgType->addButton(rbPre,GraphicsInvocationItem::Pre);
    bgType->addButton(rbPost,GraphicsInvocationItem::Post);
    bgType->addButton(rbCleanup,GraphicsInvocationItem::Cleanup);
    rbPre->setChecked(true);

    layout()->addWidget(new QLabel("Invocation value:"));
    layout()->addWidget(teValue = new QTextEdit(this));


    QHBoxLayout* hlayout = new QHBoxLayout(this);
    vlayout->addLayout(hlayout);

    QPushButton* ok = new QPushButton("Ok",this);
    QPushButton* cancel = new QPushButton("Cancel",this);

    connect(ok,SIGNAL(clicked()),SLOT(accept()));
    connect(cancel,SIGNAL(clicked()),SLOT(reject()));


    hlayout->addWidget(ok);
    hlayout->addWidget(cancel);

    // we should fill in the comboBox
    QStringList arcsTypes = ARCSFactory::getInstance()->getTypeNames();
    arcsTypes.sort();
    cbType->addItems(arcsTypes);
    cbType->setEditable(true);
    cbType->setValidator(new StringListValidator(arcsTypes,this));
}



void InvocationDialog::accept()
{
    // cbType returns the type
    // teValue returns the value

    // first we must check, if type != void, that the value is a valid one

    if (cbType->currentText() != "void")
    {
        QVariant var = ARCSFactory::getInstance()->dataDeserialize(cbType->currentText(),teValue->toPlainText());
        if (ARCSFactory::getInstance()->getVariantType(var) != cbType->currentText())
        {
            QMessageBox::critical(this,"Type parsing error",
                                  "Parsing the text \""+teValue->toPlainText()+"\" to perform an invocation of type \""+
                                  cbType->currentText()+"\" has failed.",QMessageBox::Ok,QMessageBox::NoButton);
            return;
        }
    }


    QDialog::accept();
}
