/*
  name: tools/editor/graphicsinvocationitem.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __GRAPHICSINVOCATIONITEM_H__
#define __GRAPHICSINVOCATIONITEM_H__

#include <arcs/arcsinit.h>

#include <QGraphicsPathItem>
#include <QPen>
#include <QGraphicsSceneMoveEvent>

class QGraphicsRectItem;
class QGraphicsSimpleTextItem;

class GraphicsInvocationItem : public  QGraphicsPathItem
{
public:
    //! \todo this enum should be in namespace ARCS.
    enum InvocationType {
        Pre,
        Post,
        Cleanup
    };


    GraphicsInvocationItem(QGraphicsItem* parent,InvocationType itype,ARCSInit& i);
    virtual ~GraphicsInvocationItem();

    enum {
        Type = UserType + 4
    };

    int type() const
    {
        return Type;
    }

    bool isMarkedForDeletion() { return markedForDeletion ;}
    void markForDeletion() { markedForDeletion = true; }
    ARCSInit& getInvocation() { return init; }
    InvocationType getInvocationType() { return invocationType; }

protected:
    virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
    virtual void hoverEnterEvent(QGraphicsSceneHoverEvent *);
    virtual void hoverLeaveEvent(QGraphicsSceneHoverEvent *);

private:
    void drawPath();

    bool markedForDeletion;

    InvocationType invocationType;
    QPen defaultPen;
    ARCSInit& init;
    QGraphicsRectItem* rectInvocation;
    QGraphicsSimpleTextItem* textInvocation;
    QGraphicsSimpleTextItem* textNumber;
};




#endif // __GRAPHICSINVOCATIONITEM_H__
