/*
  name: tools/editor/graphicscomponentitem.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __GRAPHICSCOMPONENTITEM_H__
#define __GRAPHICSCOMPONENTITEM_H__

#include <QGraphicsRectItem>
#include <QGraphicsSimpleTextItem>
#include <QGraphicsScene>
#include <QMap>
#include <arcs/arcsabstractcomponent.h>
#include <QPen>

#include "graphicsportitem.h"

class GraphicsComponentItem : public QGraphicsRectItem
{
public:
    GraphicsComponentItem(ARCSAbstractComponent* aac); // : QGraphicsRectItem(0,scene)
    virtual ~GraphicsComponentItem();


    enum { Type = UserType + 1 };
    int type() const
    {
         return Type;
    }


    void addSignal(QString s,bool updateSheet = true);
    void addSlot(QString s,bool updateSheet = true);

    bool isMarkedForDeletion() { return markedForDeletion; }

    void markForDeletion() { markedForDeletion = true; }
    void removePort(QString name);
    ARCSAbstractComponent* getComponent() { return component; }
    GraphicsPortItem* getSlotPort(QString name) {
        if (slotPorts.contains(name))
            return slotPorts[name];
        return 0;
    }

    GraphicsPortItem* getSignalPort(QString name) {
        if (signalPorts.contains(name))
            return signalPorts[name];
        return 0;
    }


protected:
    virtual void hoverEnterEvent ( QGraphicsSceneHoverEvent *  );
    virtual void hoverLeaveEvent ( QGraphicsSceneHoverEvent *  );
    virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event);
    virtual QVariant itemChange ( GraphicsItemChange change, const QVariant & value );
    virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
    virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *);

private:
    ARCSAbstractComponent* component;
    QGraphicsSimpleTextItem* componentLabel;
    QMap<QString,GraphicsPortItem*> slotPorts;
    QMap<QString,GraphicsPortItem*> signalPorts;
    QPen defaultPen;
    bool markedForDeletion;

};


#endif // __GRAPHICSCOMPONENTITEM_H__
