/*
  name: tools/editor/applicationview.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __APPLICATIONVIEW_H__
#define __APPLICATIONVIEW_H__

#include <QWidget>
#include <QDockWidget>
#include <arcs/arcsapplicationcomponent.h>

class QComboBox;
class QTreeWidget;
class QTreeWidgetItem;
class QAction;

class ApplicationView : public QDockWidget
{
    Q_OBJECT
public:
    explicit ApplicationView(ARCSApplicationComponent* aac = 0, QWidget *parent = 0);
    ~ApplicationView();

    ARCSApplicationComponent* getApplication() { return application; }

    void setAssociatedFile(QString s) { associatedFile = s ; }
    QString getAssociatedFile() { return associatedFile; }

signals:
    void addWidget(QWidget*);
    void defaultOwnershipRequested(ApplicationView*);
    void requestAppIdDestroy(QVariant);
    void requestWidgetDestroy(QVariant,QString);
    void requestUpdate();

public slots:
    void updateApplication();
    void requestDefaultOwnership() { emit defaultOwnershipRequested(this);}
    void addLibrary();
    void addComponent();
    void removeComponent();
    void renameComponent();

    void setApplicationMode(int mode);

    void editComponent();
    void attachController();
    void handleTreeViewClic(QTreeWidgetItem* item, int );
    void handleTreeViewDoubleClic(QTreeWidgetItem* item, int );

    void addSheet();
    void editSheet();
    void renameSheet();
    void removeSheet();

    void moveProcessUp();
    void moveProcessDown();
    void addProcess();
    void removeProcess();

protected:
    void closeEvent(QCloseEvent *event);


private:
    void buildTreeView();

    bool defaultStatus;
    ARCSApplicationComponent* application;
    QComboBox* modeList;
    QTreeWidget* treeView;
    QTreeWidgetItem* componentList;
    QTreeWidgetItem* processList;

    QAction* removeComponentAction;
    QAction* editComponentAction;
    QAction* renameComponentAction;
    QAction* attachControllerAction;
    QAction* moveProcessUpAction;
    QAction* moveProcessDownAction;
    QAction* removeProcessAction;

    QAction* addSheetAction;
    QAction* removeSheetAction;
    QAction* renameSheetAction;
    QAction* editSheetAction;

    QAction* sheetSeparatorAction;
    QAction* processSeparatorAction;
    QAction* componentSeparatorAction;

    QTreeWidgetItem* selectedCandidate;

    QString associatedFile;
};

#endif // __APPLICATIONVIEW_H__
