/*
  name: tools/editor/applicationitems.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __APPLICATIONITEMS_H__
#define __APPLICATIONITEMS_H__

#include <QTreeWidgetItem>

class ComponentItem : public QTreeWidgetItem
{

public:
    ComponentItem(QString name, QString type);

    QString getName() { return text(1); }
    QString getType() { return text(2); }

    static int Type;

};


class ProcessItem : public QTreeWidgetItem
{

public:
    ProcessItem(QString controller = QString());
    QString getController() { return text(1); }
    void setController(QString s) { setText(0,"Process <- " + s); setText(1,s); }
    static int Type;

};


class SheetItem : public QTreeWidgetItem
{
public:
    SheetItem(QString name = QString());
    QString getName() { return text(1); }
    void setName(QString s) { setText(0,"Sheet: " + s); setText(1,s); }
    static int Type;


};



#endif // __APPLICATIONITEMS_H__
