/*
  name: lib/arcsstatemachine.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include <arcs/arcsstatemachine.h>
#include <iostream>
#include <QMutableHashIterator>

ARCSStateMachine::ARCSStateMachine()
{
     error = false;
     

}

void ARCSStateMachine::renameSheet(QString oldName, QString newName)
{
    if (firstSheetName == oldName)
        firstSheetName = newName;
    if (lastSheetName == oldName)
        lastSheetName = newName;
    if (currentSheetName == oldName)
        currentSheetName = newName;

    if (transitions.contains(oldName))
    {
        QHash<QString,QString> value = transitions.take(oldName);
        transitions.insert(newName,value);
    }


    QMutableHashIterator<QString, QHash<QString,QString> > it(transitions);

    while(it.hasNext())
    {
        it.next();
        QMutableHashIterator<QString,QString> ite(it.value());

        while(ite.hasNext())
        {
            ite.next();
            if (ite.value() == oldName)
                ite.setValue(newName);
        }
    }
}


void ARCSStateMachine::addTransition(QString bState, QString token, QString eState)
{
     if (transitions.empty())
	  firstSheetName = bState;

     //lastSheetName = eState;

     if ( !transitions.contains(bState) )
	  transitions.insert(bState, QHash<QString, QString>());

     transitions[bState].insert(token, eState);
}


void ARCSStateMachine::clear()
{
     transitions.clear();
     firstSheetName = QString::null;
     lastSheetName  = QString::null;
     error = false;
}

void ARCSStateMachine::start()
{
     error = false;
     currentSheetName = firstSheetName;
     emit sendSheet(currentSheetName);
     
     if (currentSheetName == lastSheetName)
	  emit finished();

}


void ARCSStateMachine::setToken(QString s)
{
     if (transitions.contains(currentSheetName))
     {
	  if (transitions[currentSheetName].contains(s))
	  {
	       currentSheetName = transitions[currentSheetName][s];
	       emit sendSheet(currentSheetName);
	       if ( currentSheetName == lastSheetName)
		    emit finished();
          }
     }
}


void ARCSStateMachine::getTransitions(QStringList & bState, QStringList & token, QStringList & eState)
{
     bState.clear();
     token.clear();
     eState.clear();


     QHashIterator<QString, QHash<QString,QString> > it(transitions);

     while(it.hasNext())
     {
	  it.next();
	  QHashIterator<QString,QString> ite(it.value());
	  
	  while(ite.hasNext())
	  {
	       ite.next();
	       bState << (it.key());
	       token << (ite.key());
	       eState << (ite.value());
	  }
     }
}
