/*
  name: lib/arcsconstantmodifier.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include <arcs/arcsconstantmodifier.h>
#include <arcs/arcsapplicationcomponent.h>



int ARCSConstantModifier::qt_metacall(QMetaObject::Call call, int id, void ** arguments)
{
     id = QObject::qt_metacall(call,id, arguments);
     if (id == -1 || call != QMetaObject::InvokeMetaMethod)
          return id;

     if (!invertMap.contains(id))
     {
          std::cerr << "Map does not contain id " << id << std::endl;
          return -1;
     }

     ConstantAttributes ca  = invertMap[id];
     ARCSApplicationComponent* current = ARCSApplicationComponent::getRunningInstance();

     if (!current)
          return -1;

     QVariant v(ca.getType(), arguments[1]);
     QString s = ARCSFactory::getInstance()->dataSerialize(v);

     current->getContext()->modifyConstant(ca.getConstantName(),s);
     return -1;
}



QStringList ARCSConstantModifier::getSignalList() { return QStringList(); }
QStringList ARCSConstantModifier::getSlotList()  { return QStringList(); }
int ARCSConstantModifier::prepareSlotConnect(QString sigName, QString sltName, QString objectName, QString actualSignal, bool simulate)
{
     if (simulate)
          return 0;

     if (!ARCSApplicationComponent::getRunningInstance())
          return -1;

     QString signature = objectName + "." + actualSignal + "." + sigName ;

     map.insert(signature, idx);
     QString param = sigName.section("(",1,1).section(")", 0,0);
     invertMap.insert(idx, ConstantAttributes(signature, sltName,QMetaType::type(qPrintable(param)) ));
     idx ++ ;
     return idx - 1 + metaObject()->methodCount();;
}

int ARCSConstantModifier::prepareSignalConnect(QString /*sigName*/, QString /*sltName*/, QString /*objectName*/, QString /*actualSlot*/, bool /*simulate*/ )
{
     return -1;
}

int ARCSConstantModifier::cleanSlotConnect(QString sigName, QString /*sltName*/, QString objectName, QString actualSignal)
{
     QString signature = objectName + "." + actualSignal + "." + sigName ;

     int id = -1;
     if (map.contains(signature))
          id = map[signature];
     else
          return -1;

     map.take(signature);
     invertMap.take(id);

     return id + metaObject()->methodCount();
}

int ARCSConstantModifier::cleanSignalConnect(QString /*sigName*/, QString /*sltName*/, QString /*objectName*/, QString /*actualSlot*/)
{
     return -1;
}
