/*
  name: include/arcs/arcsscriptcomponent.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSSCRIPTCOMPONENT_H__
#define __ARCSSCRIPTCOMPONENT_H__

#include <arcs/arcsabstractcomponent.h>
#include <arcs/arcsqdynamicobject.h>
#include <QScriptEngine>
#include <QHash>


//! This component will be a QObject proxy in order to implement script behaviours */
/*! This class is mainly used by ARCSScriptComponent
  * \author Jean-Yves Didier
  * \date September, the 23rd, 2009
  * \ingroup lib
  */
class ARCSScriptQObjectProxy : public QObject, public ARCSQDynamicObject
{
public:
     ARCSScriptQObjectProxy(QObject* parent =0);

     virtual int qt_metacall(QMetaObject::Call, int id, void** arguments);
     virtual QStringList getSignalList();
     virtual QStringList getSlotList();

     virtual int prepareSignalConnect(QString sigName, QString sltName, QString objectName, QString actualSlot, bool simulate=false);
     virtual int prepareSlotConnect(QString sigName, QString sltName, QString objectName, QString actualSignal, bool simulate=false);

     virtual int cleanSlotConnect(QString sigName, QString sltName, QString objectName, QString actualSignal);
     virtual int cleanSignalConnect(QString sigName, QString sltName, QString objectName, QString actualSlot);

     bool setScript(QString s);

     static QScriptValue callSignal(QScriptContext* ctx, QScriptEngine* engine);
     //static QScriptValue callSignalScript(QScriptContext* ctx, QScriptEngine* engine);

private:
     QScriptEngine* engine;
     QString scriptString;
     QList<int> paramSlotCount;
     QList<QList<int> > paramSlotType;
     QList<int> paramSignalCount;
     QList<QList<int> > paramSignalType;

     QStringList slotList;
     QStringList signalList;

    static QString computeParamList(QString slt);
    void createCallSignalScript();
    static int paramCount(QString s);

     QHash<QString, QStringList> signalCollection;
};



//! Scripting components
/*!
  * ARCS offers the possibility to quickly design components using a variant
  * of ECMA-Script used by the Qt4 library.
  *
  * There are simple rules to make scripting components but they should be respected :
  * <ol>
  * <li>A function is considered as a slot;</li>
  * <li>Scripts should not be connected to scripts;</li>
  * <li>A signal call will be translated inside the script as a call to a function emit_signalName(params...);</li>
  * <li>Functions calls should not be performed as parameters of signal calls;</li>
  * <li>Signals of script components should NEVER be connected to slots of script components.</li>
  * </ol>
  *
  * Here is a slight example of a script :
  * \code
  * function squareRoot(x) { y=Math.sqrt(x); emit_squareRooted(y);  }
  * \endcode
  * This snippet of code is interpreted as a component having a slot named <tt>squareRoot</tt>
  * and a signal named <tt>squareRooted</tt>.
  * Please also notice that the following snippet of code is invalid despite its correctness with respect to ECMA-Script syntax:
  * \code
  * function squareRoot(x) { emit_squareRooted(Math.sqrt(x)); }
  * \endcode
  * The reason is that this code doesn't respect rule #4.
  * \author Jean-Yves Didier
  * \date May, 14th, 2009
  * \ingroup lib
  *
  */
class ARCSScriptComponent : public ARCSAbstractComponent
{

  public:
    ARCSScriptComponent();
    ~ARCSScriptComponent();

    virtual QString toString() { return scriptString; }
    virtual bool parseString(QString s);
    virtual QStringList getSignals() { return proxy->getSignalList(); }
    virtual QStringList getSlots() { return proxy->getSlotList(); }

 protected:
    virtual void getProxySlot (QString slot, ObjectList &obj, QStringList &proxySlot);
    virtual void getProxySignal (QString signal, ObjectList &obj, QStringList &proxySignal);
    virtual bool genuineInstanciate () { return true; }
    virtual void genuineDestroy () {}


private:
     QString scriptString;
     ARCSScriptQObjectProxy* proxy;
};





#endif // __ARCSSCRIPTCOMPONENT_H__
