/*
  name: include/arcs/arcscontrollercomponent.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSCONTROLLERCOMPONENT_H__
#define __ARCSCONTROLLERCOMPONENT_H__

#include <arcs/arcsabstractcomponent.h>
#include <arcs/arcsstatemachine.h>
#include <QMetaMethod>

//! Defines a controller component
/*!
 * Controllers are, as for now, only state machines and are parsed as statemachines.
 * Possible future release may change the underlying mechanism. 
 * 
 * \author Jean-Yves Didier
 * \date January, the 17th, 2009
 * \ingroup lib
 */
class ARCSControllerComponent : public ARCSAbstractComponent
{
public:
     ARCSControllerComponent();
     ~ARCSControllerComponent();

     virtual QStringList getSlots() { return ARCS::getMethodList(statemachine->metaObject(),QMetaMethod::Slot); }
     virtual QStringList getSignals() { return ARCS::getMethodList(statemachine->metaObject(),QMetaMethod::Signal); }
     virtual QString toString(); 
     virtual bool parseString(QString s); 

     /*! Returns the controller's associated statemachine  */
     ARCSStateMachine* getStateMachine() { return statemachine ; }


protected:

     virtual void getProxySlot(QString slot, ObjectList& obj, QStringList &proxySlot) 
     {  
	  obj << statemachine ; proxySlot << slot; 
     }
     virtual void getProxySignal(QString signal, ObjectList& obj, QStringList &proxySignal)
     {  
	  obj << statemachine ; proxySignal << signal; 
     }

     virtual bool genuineInstanciate();
     virtual void genuineDestroy();

private:
     ARCSStateMachine* statemachine;
};



#endif //__ARCSCONTROLLERCOMPONENT_H__
