/*
  name: include/arcs/arcsapplicationcomponent.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSAPPLICATIONCOMPONENT_H__
#define __ARCSAPPLICATIONCOMPONENT_H__

#include <arcs/arcsapplicationobject.h>
#include <arcs/arcscontrollercomponent.h>
#include <arcs/arcsprocess.h>
//#include <arcs/arcswrapper.h>


class ARCSAppMode;

//! This class represents an application
/*! \author Jean-Yves Didier
 * \ingroup lib
 * \date January, the 9th, 2009 
 */
class DLL_EXPORT ARCSApplicationComponent : public QObject, public ARCSAbstractComponent
{
Q_OBJECT

public:
     /*! Constructor */
     ARCSApplicationComponent(ARCS::ARCSAppFlag flag = ARCS::ARCS_APP_EVENT);


     /*! Starts the application */
     bool startApplication();
     /*! Stops the application (currently not implemented) */
     bool stopApplication();

     /*! Returns the mode in which the application is running. */
     ARCS::ARCSAppFlag getCurrentMode() { return currentMode; }
     /*! Sets the mode which the application is running */
     void setCurrentMode(ARCS::ARCSAppFlag flag) { currentMode = flag; }
     
     /*! Returns a context (i.e. a component and a constant pool) for the application */
     ARCSContext* getContext() { return &context ; }

     /*! Adds a process in the list of processes managed by the application */
     void addProcess(ARCSProcess* ap) { processes.append(ap); }
     //! Removes a process in the list of processes managed by the application
     /*! \param i the index of the process to remove
       */
     void removeProcess(int i) { ARCSProcess* ap = processes.takeAt(i); if (ap) delete ap; }

     /*! Gives the number of processes stored in the application */
     int getProcessCount() { return processes.count(); }

     void removeComponent(QString name);



     void swapProcesses(int i,int j) { processes.swap(i,j); }

     /*! Gives a particular process of the application
       * \param idx index of the process
       * \return a process structure
       */
     ARCSProcess* getProcess(int idx) { return processes.at(idx); }
     
     virtual QStringList getSlots() { return ARCS::getMethodList(defaultCore->metaObject(),QMetaMethod::Slot); }
     virtual QStringList getSignals() { return ARCS::getMethodList(defaultCore->metaObject(),QMetaMethod::Signal); }
     virtual QString toString() { return QString::null; }
     virtual bool parseString(QString s);
     virtual bool loadFile(QString fn);

     /*! Tells wether the application has finished or not (not well implemented) */
     bool hasFinished() { return applicationFinished ; }
     /*! Waits for the end of the application (useful when used as a threaded application). */
     void wait(); 

     //! This hack allows to change the value of a constant in the constant pool.
     /*! \param name name of the constant
       * \param representation string representation of the value of the constant.
       */
     void changeConstant(QString name, QString representation) { context.modifyConstant(name, representation); }

     static ARCSApplicationComponent* getRunningInstance() { return runningInstance; }


     virtual QVariant getGenuineComponentInstance();


     void* getInterface()
     {
               ARCSAbstractComponent* cmp = context.getComponent("this");
     if (cmp)
          cmp->instanciate();

          return _interface;
     }
     template<typename T> static void setInterface(T* iface) { _interface = iface; }

public slots:
     /*! Slot to trigger to finish the application (not implemented yet) */
     void finish();

signals:
     /*! Signal triggered when the application is finished. */
     void finished();

protected:

     virtual void getProxySlot(QString slot, ObjectList& obj, QStringList &proxySlot) 
     {  
       obj << defaultCore ; proxySlot << slot;
     }
     virtual void getProxySignal(QString signal, ObjectList& obj, QStringList &proxySignal)
     {  
       obj << defaultCore ; proxySignal << signal;
     }

     virtual bool genuineInstanciate() { return true; }
     virtual void genuineDestroy() { }


private:

     static ARCSApplicationComponent* runningInstance;

     ARCSContext context;
     QList<ARCSProcess*> processes ;
     
     //ARCSApplicationObject* applicationCore;
     static ARCSApplicationObject* defaultCore;

     ARCS::ARCSAppFlag currentMode;
     bool applicationFinished;

     static void* _interface;
};



#endif //__ARCSAPPLICATIONCOMPONENT_H__
