/*
  name: boucle.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include <qobject.h>
#include <qstring.h>

class Boucle: public QObject
{
Q_OBJECT
     public:
Boucle(QObject* parent = 0, const char* name = 0);

public slots:
     void setIterations(int n);

signals:
void newIteration(int i);
void sendToken(QString s);
};


class DisplayInt: public QObject
{
Q_OBJECT
     public:
DisplayInt(QObject* parent = 0, const char* name = 0);

public slots:
     void display(int i);
};

class ComponentNester: public QObject
{
Q_OBJECT
    public:
ComponentNester(QObject* parent = 0, const char* name =0);

public slots:
    void setNestedComponent(QObject* obj);
    void setIterations(int);

private :
    QObject* nestedComponent;

};


class IntReader: public QObject
{
Q_OBJECT
public:
IntReader(QObject* parent=0, const char* name=0) : QObject (parent, name) {}

public slots:
	void setFilename(QString s) { filename=s; }
	void start();

signals:
void newIteration(int i);
void sendToken(QString s);

private:
	QString filename;
};

