/*
  name: main.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include <qapplication.h>
#include <qstring.h>
#include <qtimer.h>
#include <metalibrary/metaruntime.h>
#include <iostream>

/*! \mainpage ARCS Core system
 *
 * Here is the documentation associated to Runtime API.
 *  
 * The two main starting points to understand this API are :
 * <ul>
 * <li> The file metalibrarytoolkit.h, explaining how to generate a library
 * compatible with runtime.</li>
 * <li> The class MetaConfigReader, detailing how xml files are read and how 
 * the different classes composing runtime are instanciated from it. </li>
 * <li> The class MetaRuntime will show you the structure of the main runtime core. 
 * It is now possible to inherit from it to embed this runtime inside another application. </li>
 * </ul>
 *
 * This classes are also generating the runtime program.
 * The only parameter needed by it is the path of the xml file describing an application. 
 */ 


using namespace std;


int main(int argc, char* argv[])
{
     int configIdx = 1;
     QApplication* app = 0;

     if(argc > 3 || argc < 2 )
     {
	  cerr << "Usage : " << argv[0] << " [-s] config_file" << endl;
	  cerr << "Where : config_file is an xml file describing application." << endl;
	  cerr << "        -s is a switch for a synchronized execution (non event driven)." << endl;
	  return 1;
     }


     if (argc == 3)
     {
	  if (argv[1] == QString("-s"))
	  {
	       configIdx = 2;
	  }
     }
     else
     {
	  app= new QApplication(argc, argv);
     }


     MetaRuntime mr;
     
     return mr.startRuntime(argv[configIdx],(argc != 3)); 
}

