/*
  name: metastatemachine.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include <metalibrary/metastatemachine.h>
#include <iostream>
//#define DEBUG

using namespace std;

MetaStateMachine::MetaStateMachine() 
{
     state = QString();
     firstState = QString();
     terminalState = QString();
     transitions.setAutoDelete(true);
}


MetaStateMachine::~MetaStateMachine()
{

}

void MetaStateMachine::clear()
{
     transitions.clear();
     state = QString();
     firstState = QString();
     terminalState = QString();
}


void MetaStateMachine::insertTransition(QString a, QString b, QString t)
{
     MetaTokenAlternative* pmta = transitions[a];

     if ( pmta == NULL)
     {
	  pmta = new MetaTokenAlternative();
	  transitions.insert(a, pmta);
     }
     (*pmta)[t] = b;

#ifdef DEBUG
     cout << "Inserting transition " << a.ascii() << ", " << b.ascii() << ", " << t.ascii() << "." << endl;
#endif

}


bool MetaStateMachine::changeState(QString t)
{
     MetaTokenAlternative* pmta = transitions.find(state);

     
     if (pmta == NULL)
     {
	  cerr  << "[META] State " << state.ascii() << " not found in state machine." << endl;
	  return false;
     }

     MetaTokenAlternative::iterator it2 = (*pmta).find(t);
     if (it2 == (*pmta).end())
     {
	  cerr << "[META] Token " << t.ascii() << " not found in transitions concerning state " << state.ascii() << endl;
	  return false;
     }
#ifdef DEBUG
     cout << "[META]Switching from sheet "<< state.ascii() <<" to " << it2.data().ascii() << endl;
#endif
     state = it2.data();

     return true;
}



void MetaStateMachine::start()
{
     if (firstState.isEmpty())
     {
	  QDictIterator<MetaTokenAlternative> it(transitions);
	  
	  if (it == NULL)
	  {
	       state = QString();
	       return;
	  }
	  state = it.currentKey();
     }
     else
	  state =  firstState;
}


ostream& operator<<(ostream& os, const MetaStateMachine& msm)
{
//     MetaTransition::iterator it; // = msm.transitions.begin();
//     QMapIterator<QString, QMap<QString,QString> > it;
//     for (it = (msm.transitions).begin(); it != (msm.transitions).end() ; ++it)
//     {
//	  os << it.key().ascii() << endl;;
	  
//     }


//     QValueList<QString> vl = msm.transitions.keys();
     

//     QValueList<QString>::iterator it;
//     os << "States list :" << endl;
//     for ( it = vl.begin(); it != vl.end(); ++it )
//	  os << (*it).ascii() << endl;


     return os; 
}

