/*
  name: wirecanvas.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/



//#include "metabase.h"
#include "wirecanvas.h"
//#include <qlabel.h>
//#include <qfontmetrics.h>
//#include "linewire.h"
#include <cstdlib>

WireCanvas::WireCanvas(MetaWire* mw, NodeItem *from, NodeItem *to, int p1, int h1, int p2, int h2)
    : QCanvasLine( to->canvas() )
{
     myWire = mw;
     myFrom = from;
     myTo = to;
     //on cr les 5 ligne qui permettrons de faire nos Wires
     for ( int i=0 ; i<5 ; i++ ) {
	  lineWire[i] = new LineWire(this);
	  lineWire[i]->setBrush( QColor(0,0,0) );
     }

/* les x sont les points A,B,C et D sont les points qui relient les Lignes 0,1,2,3 et 4

     Signal(from) >--0--A--1--B
                              |
                              2
                              |
                              C--3--D--4--< Slot(to) 

ou

                             Signal(from) >--0--A
                                                |
                                                1
                                                |
				    C-----2-----B
				    |
				    3
				    |
				    D--4--< Slot(to)

ou

                     D--4--< Slot(To)             Signal(from) >--0--A
		     |                                               |
		     |                                               | 
		     3					             1
		     |                                               |
		     |					             |
		     C-----------------------2-----------------------B

*/

     //si le node from est a gauche du node To
     if ( myFrom->x() < (myTo->x() -40) ) {
	  lineWire[0]->setPoints( int(myFrom->x()+5), int(myFrom->y()+5), 
				 int(myFrom->x()+20), int(myFrom->y()+5) );
	  
	  lineWire[1]->setPoints( int(myFrom->x()+20), int(myFrom->y()+5), 
				 int((myFrom->x()+myTo->x())/2), int(myFrom->y()+5) );
	  
	  lineWire[2]->setPoints( int((myFrom->x()+myTo->x())/2), int(myFrom->y()+5), 
				 int((myFrom->x()+myTo->x())/2), int(myTo->y()+5) );
	  
	  lineWire[3]->setPoints( int((myFrom->x()+myTo->x())/2), int(myTo->y()+5),
				 int(myTo->x()-20), int(myTo->y()+5) );
	  
	  lineWire[4]->setPoints( int(myTo->x()-20), int(myTo->y()+5),
				 int(myTo->x()), int(myTo->y()+5) );  
	  ThreeToFive = false;
     }
     else {
	  //si on peux passer au milieu des deux objet
	    if (( p1+h1+30 ) > p2 ) {
	       lineWire[0]->setPoints( int(myFrom->x()+5), int(myFrom->y()+5), 
				      int(myFrom->x()+20), int(myFrom->y()+5) );
	       
	       lineWire[1]->setPoints( int(myFrom->x()+20), int(myFrom->y()+5), 
				      int(myFrom->x()+20), int(p2+h2+30));
	       
	       lineWire[2]->setPoints( int(myFrom->x()+20), int(p2+h2+30), 
				      int(myTo->x()-20), int(p2+h2+30));
	       
	       lineWire[3]->setPoints( int(myTo->x()-20), int(p2+h2+30),
				      int(myTo->x()-20), int(myTo->y()+5) );
	       
	       lineWire[4]->setPoints( int(myTo->x()-20), int(myTo->y()+5),
				      int(myTo->x()), int(myTo->y()+5) );
	  }
	  else {    
	       lineWire[0]->setPoints( int(myFrom->x()+5), int(myFrom->y()+5), 
				      int(myFrom->x()+20), int(myFrom->y()+5) );
	       
	       lineWire[1]->setPoints( int(myFrom->x()+20), int(myFrom->y()+5), 
				      int(myFrom->x()+20), int(abs((p1+h1+30+p2)/2)));
	       
	       lineWire[2]->setPoints( int(myFrom->x()+20), int(abs((p1+h1+30+p2)/2)), 
				      int(myTo->x()-20), int(abs((p1+h1+30+p2)/2)));
	       
	       lineWire[3]->setPoints( int(myTo->x()-20), int(abs((p1+h1+30+p2)/2)),
				      int(myTo->x()-20), int(myTo->y()+5) );
	       
	       lineWire[4]->setPoints( int(myTo->x()-20), int(myTo->y()+5),
				      int(myTo->x()), int(myTo->y()+5) );
	  }
	  ThreeToFive = true;
     }     

     //on cr les 4 grips qui permettront de dplacer les line
     
     for ( int i=0; i<4 ; i++ ) {
	  gripPoint[i] = new GripWire(0,this);    
	  gripPoint[i]->move(lineWire[i]->endPoint().x()-3,lineWire[i]->endPoint().y()-3);
	  gripPoint[i]->setNum(i);
     }
     // on affiche les line
     for ( int i=0 ; i<5 ; i++ )
	  lineWire[i]->show();
}

WireCanvas::~WireCanvas()
{
     for ( int i=0 ; i<5 ; i++ )
	  delete lineWire[i];
     
     for ( int i=0; i<4 ; i++ )
	  delete gripPoint[i];
}


void WireCanvas::setFromPoint(int x, int y)
{
     lineWire[0]->setPoints( lineWire[0]->startPoint().x()+x, lineWire[0]->startPoint().y()+y, 
			    lineWire[0]->endPoint().x()+x, lineWire[0]->endPoint().y()+y );
     setPoint(x,y);
}

void WireCanvas::setToPoint(int x, int y)
{
     lineWire[4]->setPoints( lineWire[4]->startPoint().x()+x, lineWire[4]->startPoint().y()+y,
			    lineWire[4]->endPoint().x()+x, lineWire[4]->endPoint().y()+y );
     setPoint(x,y);
}

void WireCanvas::setPoint(int x, int y)
{
      // if ( myFrom->x() < (myTo->x() -40) ) {
     if (  lineWire[0]->endPoint().x() < lineWire[4]->startPoint().x() ) {
     //cout<<"from a gauche"<<endl;
	  if ( FiveToThree )
	       lineWire[0]->setPoints( int(myFrom->x()+5), int(myFrom->y()+5), 
				      int(myFrom->x()+20), int(myFrom->y()+5) );
// voir avec si line0.end.X < line3.start.X
	       else 
	       FiveToThree = true;
	  
	  lineWire[1]->setPoints( lineWire[0]->endPoint().x(), lineWire[0]->endPoint().y(), 
				 lineWire[2]->endPoint().x()+int(x/2), lineWire[0]->endPoint().y() );

	  lineWire[2]->setPoints( lineWire[1]->endPoint().x(), lineWire[0]->endPoint().y(), 
				 lineWire[1]->endPoint().x(), lineWire[4]->startPoint().y() );
	  
	  lineWire[3]->setPoints( lineWire[1]->endPoint().x(), lineWire[4]->startPoint().y(),
				 lineWire[4]->startPoint().x(), lineWire[4]->startPoint().y() );
	  ThreeToFive = false;
     }
     else {
	  //cout<<"from a droite"<<endl;
	  if ( !ThreeToFive ) {
	       lineWire[1]->setPoints( lineWire[0]->endPoint().x(), lineWire[0]->endPoint().y(), 
				      lineWire[0]->endPoint().x(), int((abs((int)(myFrom->y()+myTo->y()))/2)) );
	       ThreeToFive = true;	
	  }	  
	  else  
	       lineWire[1]->setPoints( lineWire[0]->endPoint().x(), lineWire[0]->endPoint().y(), 
				      lineWire[0]->endPoint().x(), lineWire[1]->endPoint().y()+int(y/2) );
	  
	  
	  lineWire[2]->setPoints( lineWire[0]->endPoint().x(), lineWire[1]->endPoint().y(), 
				 lineWire[4]->startPoint().x(), lineWire[1]->endPoint().y() );
	  
	  lineWire[3]->setPoints( lineWire[4]->startPoint().x(), lineWire[1]->endPoint().y(),
				 lineWire[4]->startPoint().x(), lineWire[4]->startPoint().y() );     
	  FiveToThree = true;
     }

     for ( int i=0; i<4 ; i++ ) {
	  gripPoint[i]->move(lineWire[i]->endPoint().x()-3,lineWire[i]->endPoint().y()-3);
     }
}

void WireCanvas::setVisibleGrip(bool visible)
{
     // rend tout les grip soit visible soit invisble
     for ( int i=0; i<4 ; i++ ) 
     {
	  if (gripPoint[i] != NULL)
	  {
	       gripPoint[i]->move(lineWire[i]->endPoint().x()-3,lineWire[i]->endPoint().y()-3);
	       gripPoint[i]->setVisible(visible);   
	  }
		    
     }
/*     gripPoint[1]->setVisible(visible);   
     gripPoint[2]->setVisible(visible);   
     gripPoint[3]->setVisible(visible);   */
}



/********************************************************************************/



NodeItem::NodeItem( QCanvasItem *oc, int x, int y, QString label , bool isSlot) :
     QCanvasPolygon( oc->canvas() )
{
     slotProperty = isSlot;
     nodeName = label;
     ocNode = oc;
  
     sLabel = new QCanvasText( label, oc->canvas());
     // selon si c un slot ou un signal le texte est plac soit a droite soit a gauche
     if ( isSlot ) {
	  sLabel->move(10,-2);//5 pour la taille du triangle et 5 pour le dcalage
	  sLabel->setTextFlags(Qt::AlignLeft);
     }
     else {
	  sLabel->move(-5,-2);
	  sLabel->setTextFlags(Qt::AlignRight); 
     }

     sLabel->setZ(700);//a mieu gerer
     QFont fnt("Times",10);
     sLabel->setFont(fnt);
     QFontMetrics fntm(fnt);
     width = fntm.width(label);
     height = fntm.height();

     sLabel->show();

     // crtion du triangle
     QPointArray pa(3);
     pa[0] = QPoint(0,0);
     pa[1] = QPoint(5,5);
     pa[2] = QPoint(0,10);
     setPoints(pa);
     setBrush( QColor(0,0,0) );
     move(x,y);
     setZ(700);
     show();   
}

NodeItem::~NodeItem()
{
     delete sLabel;
}

void NodeItem::moveBy(double dx, double dy)
{
    QCanvasPolygon::moveBy( dx, dy );
    sLabel->moveBy(dx,dy);
}

void NodeItem::setZ(double z)
{
     QCanvasPolygon::setZ(z);
//marche pas ;_;
     //cout<<z<<endl;
     sLabel->setZ(z+3);
}
