/*
  name: projectwriter.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "projectwriter.h"
//#include "statemachineview.h"
//#include "statecanvas.h"
#include "objectcanvas.h"
#include "wirecanvas.h"

#include <qfile.h>


ProjectWriter::ProjectWriter(bool b)
{
     QDomElement eGraphique = graphique.createElement("graphique");
     graphique.appendChild(eGraphique);
     
     eApplication = graphique.createElement("application");
     eGraphique.appendChild(eApplication);
     eSheets = graphique.createElement("sheets");
     eGraphique.appendChild(eSheets);
     block = b;
}


ProjectWriter::~ProjectWriter()
{

}


bool ProjectWriter::writeFile(QString filename)
{
     QFile file( filename );
     if ( !file.open( IO_WriteOnly ) )
     {
          std::cerr << "Couldn't open project file for saving." << endl;
          return false;
     }
     QTextStream ts(&file);
     graphique.save(ts, 4);
     file.close();
     return true;
}

void ProjectWriter::addApplication(QString fileName)
{
     if (block)
	  eApplication.setAttribute("fileBlock", fileName);
     else
	  eApplication.setAttribute("fileApplication", fileName);
}

void ProjectWriter::addSheet(SheetView* sv, StateCanvas* sc)
{
     QDomElement e = graphique.createElement("sheet");

     if (sc != NULL)
     { 
	  e.setAttribute("id", strippedName(sc->getName()));
	  e.setAttribute("x", sc->x());
	  e.setAttribute("y", sc->y());
     }

     QDomElement object = graphique.createElement("objects");
     QDomElement wire = graphique.createElement("wires");
     e.appendChild(object);
     e.appendChild(wire);
     eSheets.appendChild(e);

     QDictIterator<ObjectCanvas> itoc( sv->getObjectIterator() ) ;
     for ( ; itoc.current() ; ++itoc)
     {
	  //cout<<"export object : "<<itoc.currentKey().ascii()<<endl;
	  QDomElement f = graphique.createElement("object");
	  ObjectCanvas *oc = itoc.current();
	  f.setAttribute("id", strippedName(oc->getObjectID()));
	  f.setAttribute("x", oc->x());
	  f.setAttribute("y", oc->y());
	  object.appendChild(f);

	  //pour chaque objet plusieur Wire
	       
	  QDictIterator<WireCanvas> itwc( oc->getWireIterator() ) ;
	  for ( ; itwc.current() ; ++itwc)
	  {
	       QDomElement g = graphique.createElement("wire");
	       MetaWire *mw = itwc.current()->getMetaWire();
	       g.setAttribute("objsource", strippedName(mw->getSender()));
	       g.setAttribute("signal", mw->getSignal());
	       g.setAttribute("objdest", strippedName(mw->getReciever()));
	       g.setAttribute("slot", mw->getSlot());
	       wire.appendChild(g);

	       for ( uint i=0; i<4 ; i++) {
		    QDomElement grip = graphique.createElement("grip");
		    grip.setAttribute("x",(itwc.current()->getGripPoint(i))->x());
		    grip.setAttribute("y",(itwc.current()->getGripPoint(i))->y());
		    g.appendChild(grip);
	       }
	  }
	       
     }
}




void ProjectWriter::addSheets(QDictIterator<StateCanvas> itsc, QDict<SheetView> svs )
{
     for ( ; itsc.current() ; ++itsc)
     {
	  SheetView* sv = svs[itsc.current()->getName()];
	  if (sv == NULL)
	       std::cerr << "Sheet not found for export" << endl;
	  else
	       addSheet(sv,itsc.current());
     }
}
