/*
  name: objectdialog.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "objectdialog.h"

#include <iostream>

#include <qvbox.h>
#include <qstringlist.h>
#include <qstrlist.h>
#include <qmessagebox.h>

using namespace std;

ObjectDialog::ObjectDialog( QWidget *parent, const char *name , MetaLibrary metalib, SheetView* sw)
     : QDialog( parent, name, TRUE, 0)
{
     sheet = sw;

     setCaption("Ajouter un objet");
// Mise en place des elements
     QVBox *vb1 = new QVBox( this );
     vb1->resize( 450, 400 );

     
     QHBox *hb0 = new QHBox( vb1 );
     hb0->setMargin( 8 );
     hb0->setSpacing( 5 );
     new QLabel( "<font color=red><u><b>""Classe(s) Disponible(s)</b></u></font>", hb0 );
     if (!sw->isMacroblock())
	  new QLabel( "<font color=blue><u><b>""Objet(s) existant(s)</b></u></font>", hb0 );     

     QHBox *hb1 = new QHBox( vb1 );
     hb1->setMargin( 8 );
     hb1->setSpacing( 5 );
     QVBox *vb11 = new QVBox( hb1 );
    
     vb11->setMaximumWidth( 170 );
     listClass = new QListView( vb11 );
     listClass->addColumn( "ClassName" );
     listClass->setResizeMode ( QListView::AllColumns );
     listClass->setAllColumnsShowFocus( TRUE );
     listClass->setShowSortIndicator( TRUE );
     listClass->clearFocus(); 
     classSelect = FALSE ;
     connect( listClass, SIGNAL(clicked(QListViewItem*)), this, SLOT(classClick()));

    
     QHBox *hb11 = new QHBox( vb11 );
     hb11->setMargin( 5 );
     hb11->setSpacing( 5 );
     new QLabel("<font color=darkgreen size=3>""Set ID</font>",hb11);     
     IDSearch = new QLineEdit( "", hb11 );
     IDSearch->setMaximumSize ( 110, 25 );
     connect( IDSearch, SIGNAL(textChanged ( const QString & )), this, SLOT(textSearch())); 

     QVBox *vb12 = new QVBox( hb1 ); 

     if (sw->isMacroblock())
	  listObject = new QListView( NULL );
     else
	  listObject = new QListView( vb12 );

     listObject->addColumn( "ID" );
     listObject->addColumn( "Object" );
     listObject->setResizeMode ( QListView::AllColumns );
     listObject->setAllColumnsShowFocus( TRUE );
     listObject->setShowSortIndicator( TRUE );
     connect( listObject, SIGNAL(clicked(QListViewItem*)), this, SLOT(objectClick()));
  
     QHBox *hb2 = new QHBox( vb1 );
     QVBox *vb21 = new QVBox( hb2 );
     vb21->setMargin( 10 );
     vb21->setSpacing( 0 );
     vb21->setMinimumWidth( 330 );
     msgWarning = new QLabel( vb21);
     connect( this,  SIGNAL(explain(const QString&)), msgWarning, SLOT(setText(const QString&)) );
     QVBox *vb23 = new QVBox( hb2 ); 
     QHBox *hb3 = new QHBox( vb23 );
     hb3->setMargin( 5 );
     hb3->setSpacing( 0 );
     ok = new QPushButton( "Ok", hb3 );
     ok->setMaximumWidth( 40 );
          
     connect( ok, SIGNAL(clicked()), SLOT(acceptObject()) );
     cancel = new QPushButton( "Cancel", hb3 );
     cancel->setMaximumWidth(70);
     connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

    // Recherche des donnes

     MetaLibrary ml = metalib;
     QStringList objects = ml.getObjects();

     for (unsigned int i = 0; i < objects.count() ; i++)
     {
	  listClass->insertItem( new QListViewItem( listClass,objects[i])); 
     }
     listClass->insertItem(new QListViewItem(listClass,"MetaBlock"));
     listClass->setSelected(listClass->firstChild(), TRUE);

     QDictIterator<MetaObject> ite = MetaObject::getIterator();
     

     classSelect = true;


     for (; ite.current(); ++ite)
     {
	  if (sw->isMacroblock())
	  {
	       QString key = ite.currentKey();
	       if (key.startsWith(sw->name()))
	       {
		    listObject->insertItem(new QListViewItem(listObject, key, ite.current()->getClassName()));
	       }
	  }
	  else
	       if (!ite.currentKey().contains("::"))
		    listObject->insertItem(new QListViewItem( listObject, ite.currentKey(), ite.current()->getClassName()));

     }
}

ObjectDialog::~ObjectDialog()
{
     if (listObject->parent() == NULL)
	  delete listObject;

}


void ObjectDialog::acceptObject()
{
     //si selection dans liste gauche
     if ( classSelect ) {
	  if (fullName(IDSearch->text()).isEmpty() ) { 
	       QMessageBox::information( this, "Pour ajouter un objet",
					 "Pour ajouter un objet, il faut selectionner\n"
					 "une classe et dfinir un ID." ); 
	  }
	  else {
/*
  isRegister + isInSheet = msg existe deja sur la feuille
  isRegister = msg voulez vous rajouter sur cette feuille(il existe deja sur une autre)+ si oui rajouter l'objet
  rien = ajouter
*/
	       if ( isRegister&&isInSheet )
		    QMessageBox::information( this, "Pour ajouter un objet",
					      "Cet Objet existe dj sur la feuille\n"
					      "Veuillez dfinir un autre ID." );
	       else {
		    if ( isRegister&&!(isInSheet) ) {
			 QMessageBox q(  "Ajouter un objet",
					 "Voulez-vous ajouter cet objet\n"
					 " votre feuille?",
					 QMessageBox::Question,  
					 QMessageBox::Yes | QMessageBox::Default,
					 QMessageBox::No  | QMessageBox::Escape,
					 QMessageBox::NoButton  ); 
			 if ( q.exec() == QMessageBox::Yes ) {
			      if (sheet != NULL)
				   sheet->addObject(MetaObject::getObject(listObject->currentItem()->text(0)));
			      accept();
			 }
		    }
		    else {
			 if (sheet != NULL)
			 {
			      if (listClass->currentItem()->text(0) == "MetaBlock" )
				   sheet->addObject(new MetaBlock(fullName(IDSearch->text())));
			      else
				   sheet->addObject(new MetaObject(listClass->currentItem()->text(0), fullName(IDSearch->text())));
			 }
			 accept();
		    }
	       }
	  }
     }
     else {
//on a selectionn un objet deja existant(liste droite)
	  isInSheet = false ;
	  if (sheet != NULL)
	       isInSheet = sheet->hasObject(listObject->currentItem()->text(0));
	  if ( isInSheet )
		    QMessageBox::information( this, "Pour ajouter un objet",
					      "Cet Objet existe dj sur la feuille");
	  else {
	       QMessageBox q(  "Ajouter un objet",
			       "Voulez-vous ajouter cet objet\n"
			       " votre feuille?",
			       QMessageBox::Question,  
			       QMessageBox::Yes | QMessageBox::Default,
			       QMessageBox::No  | QMessageBox::Escape,
			       QMessageBox::NoButton  ); 
	       if ( q.exec() == QMessageBox::Yes ) {
		    if (sheet != NULL)
			 sheet->addObject(MetaObject::getObject(listObject->currentItem()->text(0)));
		    accept();
	       }
	  }
     }
}

 

void ObjectDialog::textSearch()
{
     QDictIterator<MetaObject> it = MetaObject::getIterator();
     QListViewItem* tmp = NULL;
  
     listObject->clearSelection ();

     for ( ; it.current(); ++it)
     {
//	  cout << "Comparing '" << it.currentKey().ascii() << "' and '" << fullName(IDSearch->text()).ascii() << "'" << endl;

	  if ( it.currentKey() ==  fullName(IDSearch->text()) )
	  {
	       if (tmp != NULL) 
	       {
//		    cout << " tmp non null " << endl;
		    if (it.currentKey().length() <= tmp->text(0).length())
			 tmp = listObject->findItem(it.currentKey(), 0, ExactMatch);
	       }
	       else
	       {
//		    cout << "tmp null" << endl;
		    tmp = listObject->findItem(it.currentKey(), 0, ExactMatch);      
//		    if (tmp == NULL)
//			 cout << " tmp toujours null" << endl;
	       }
	  }
     }
     isRegister = false;
     if (tmp != NULL) {
	  isRegister = true;
	  listObject->setSelected(tmp, TRUE);
	  isInSheet = false ;
	  //cout << "Testing item " << tmp->text(0).ascii() << endl;
	  if (sheet != NULL)
	       isInSheet = sheet->hasObject(tmp->text(0));
	  if ( isInSheet )
	       emit explain( "<font color=red size=3><u>""Attention</u>, cet ID est dj prsent sur la feuille !</font>" );       
     }     
     else
	  emit explain( QString::null);
}

void ObjectDialog::classClick()
{
     classSelect = true;
     listObject->clearSelection ();
//force la surbrillance
     listClass->setSelected(listClass->currentItem(), TRUE);
}
void ObjectDialog::objectClick()
{
     classSelect = false;
     listClass->clearSelection ();
     listObject->setSelected(listObject->currentItem(), TRUE);
}
