/*
  name: gripwire.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "gripwire.h"
#include "wirecanvas.h"


GripWire::GripWire( int n, QCanvasItem* wc)
    : QCanvasRectangle(wc->canvas())
{
     wireGrip = wc;
     num = n;
     setSize(7,7); 
     setBrush( QColor(170, 100, 190) );
     setZ(100);
}

GripWire::~GripWire()
{
//     delete grip;
     wireGrip = NULL;
}


void GripWire::moveGrip(double dx, double dy)
{
       switch(num)
       {
       case 0:
	    moveGrip0(dx);
	    break;
       case 1:
	    moveGrip1(dx,dy);
	    break;
       case 2:
	    moveGrip2(dx, dy);
       break;
       case 3:
	    moveGrip3(dx);
       break;
       }
}


void GripWire::moveGrip0( double dx)
{
     GripWire *gw1 = ((WireCanvas*)wireGrip)->getGripPoint(1);
     QCanvasLine *lw0 = ((WireCanvas*)wireGrip)->getLineWire(0);
     QCanvasLine *lw4 = ((WireCanvas*)wireGrip)->getLineWire(4);

     if (  lw0->endPoint().x() > lw4->startPoint().x() ) {
	  //cout<<"to a gauche"<<endl;
	  if ( ( x() - ((WireCanvas*)wireGrip)->getFromNode()->x() + dx) >= 17 )
	  {  
	       QCanvasRectangle::moveBy(dx, 0);
	       gw1->moveBy(dx, 0);
	       setLine();
	  }
     }
     else {
	  //cout<<"to a droite"<<endl;
	  if ( ( ( x() - ((WireCanvas*)wireGrip)->getFromNode()->x() + dx) >= 17 )
	       && ( gw1->x() >= ( x() + dx ) ) ) 
	  {
	       QCanvasRectangle::moveBy(dx, 0);
	       setLine();
	  }
     }
}

void GripWire::moveGrip1( double dx, double dy)
{
     GripWire *gw0 = (((WireCanvas*)wireGrip)->getGripPoint(0));
     GripWire *gw2 = (((WireCanvas*)wireGrip)->getGripPoint(2));
     GripWire *gw3 = (((WireCanvas*)wireGrip)->getGripPoint(3));
     QCanvasLine *lw0 = (((WireCanvas*)wireGrip)->getLineWire(0));
     QCanvasLine *lw4 = (((WireCanvas*)wireGrip)->getLineWire(4));

     if (  lw0->endPoint().x() >= lw4->startPoint().x() ) {
	  //cout<<"to a gauche"<<endl;
	  if ( ( ( x() - ((WireCanvas*)wireGrip)->getFromNode()->x() + dx) >= 17 )
	       && ( ( x()+dx ) >= gw2->x() ) )
	  {
	       QCanvasRectangle::moveBy(dx, dy);
	       gw0->setX(x());
	       gw2->setY(y());
	       setLine();
	  }
	  else {
	       QCanvasRectangle::moveBy(0, dy);
	       gw2->setY(y());
	       setLine();
	  }
	  
     }
     else {
	  //cout<<"to a droite"<<endl;
	  if ( ( ( x()+dx ) >= gw0->x()  )
	       && ( ( x()+dx ) <= gw3->x() ) )
	  {
	       QCanvasRectangle::moveBy(dx, 0);
	       gw2->setX(x());
	       setLine();
	  }
     }
}

void GripWire::moveGrip2( double dx, double dy)
{
     GripWire *gw0 = (((WireCanvas*)wireGrip)->getGripPoint(0));
     GripWire *gw1 = (((WireCanvas*)wireGrip)->getGripPoint(1));
     GripWire *gw3 = (((WireCanvas*)wireGrip)->getGripPoint(3));
     QCanvasLine *lw0 = (((WireCanvas*)wireGrip)->getLineWire(0));
     QCanvasLine *lw4 = (((WireCanvas*)wireGrip)->getLineWire(4));

     if (  lw0->endPoint().x() >= lw4->startPoint().x() ) {
     //cout<<"to a gauche"<<endl;
	  if ( ( ( ((WireCanvas*)wireGrip)->getToNode()->x() - x() - dx) >= 23  )
	       && ( ( x()+dx ) <= gw1->x() ) )
	  {
	       QCanvasRectangle::moveBy(dx, dy);
	       gw1->setY(y());
	       gw3->setX(x());
	       setLine();
	  }
	  else {
	       QCanvasRectangle::moveBy(0, dy);
	       gw1->setY(y());
	       setLine();
	  }
     }
     else {
	  //cout<<"to a droite"<<endl;
	  if ( ( ( x()+dx ) >= gw0->x()  )
	       && ( ( x()+dx ) <= gw3->x() ) )
	  {
	       QCanvasRectangle::moveBy(dx, 0);
	       gw1->setX(x());
	       setLine();
	  }
     }
}

void GripWire::moveGrip3( double dx)
{
     GripWire *gw2 = (((WireCanvas*)wireGrip)->getGripPoint(2));
     QCanvasLine *lw0 = (((WireCanvas*)wireGrip)->getLineWire(0));
     QCanvasLine *lw4 = (((WireCanvas*)wireGrip)->getLineWire(4));

     if (  lw0->endPoint().x() > lw4->startPoint().x() ) {
	  //cout<<"to a gauche"<<endl;
	  if ( ( ((WireCanvas*)wireGrip)->getToNode()->x() - x() - dx) >= 23  )
	  {  
	       QCanvasRectangle::moveBy(dx, 0);
	       gw2->moveBy(dx, 0);
	       setLine();
	  }
     }
     else {
	  //cout<<"to a droite"<<endl;
	  if ( ( ( ((WireCanvas*)wireGrip)->getToNode()->x() - x() - dx) >= 23  ) 
	       && ( gw2->x() <= ( x() + dx ) ) ) 
	  {
	       QCanvasRectangle::moveBy(dx, 0);
	       setLine();	  
	  }
     }
}


void GripWire::setLine()
{
     GripWire *gw0 = (((WireCanvas*)wireGrip)->getGripPoint(0));
     GripWire *gw1 = (((WireCanvas*)wireGrip)->getGripPoint(1));
     GripWire *gw2 = (((WireCanvas*)wireGrip)->getGripPoint(2));
     GripWire *gw3 = (((WireCanvas*)wireGrip)->getGripPoint(3));
     QCanvasLine *lw0 = (((WireCanvas*)wireGrip)->getLineWire(0));
     QCanvasLine *lw1 = (((WireCanvas*)wireGrip)->getLineWire(1));
     QCanvasLine *lw2 = (((WireCanvas*)wireGrip)->getLineWire(2));
     QCanvasLine *lw3 = (((WireCanvas*)wireGrip)->getLineWire(3));
     QCanvasLine *lw4 = (((WireCanvas*)wireGrip)->getLineWire(4));

     //Redefinition des lineWires suivant la position des points
     lw0->setPoints(lw0->startPoint().x(),lw0->startPoint().y(),int(gw0->x()+3),int(gw0->y()+3));
     lw1->setPoints(int(gw0->x()+3),int(gw0->y()+3),int(gw1->x()+3),int(gw1->y()+3));	  
     lw2->setPoints(int(gw1->x()+3),int(gw1->y()+3),int(gw2->x()+3),int(gw2->y()+3));
     lw3->setPoints(int(gw2->x()+3),int(gw2->y()+3),int(gw3->x()+3),int(gw3->y()+3));
     lw4->setPoints(int(gw3->x()+3),int(gw3->y()+3),lw4->endPoint().x(),lw4->endPoint().y());
}
