/*
  name: blockdialog.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "blockdialog.h"

#include <qvbox.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qmessagebox.h>

BlockDialog::BlockDialog(QWidget* parent, const char* name)
     : QDialog(parent, name, true)
{
     setCaption("Select ...");
     
     QVBox* vb0 = new QVBox(this);
     vb0->resize(300,400);
     new QLabel("Select an existing meta-block:",vb0);
     lstBox = new QListBox(vb0);
     //lstBox->setMinimumHeight(300);
     //lstBox->setMaximumWidth(200);
     new QLabel("Or select a file:",vb0);
     QHBox* hb0= new QHBox(vb0);
     line = new QLineEdit(hb0);
     tripoint = new QPushButton( "...", hb0);
     tripoint->setMaximumWidth(50);
     
     QHBox* hb1= new QHBox(vb0);
     ok     = new QPushButton("Ok", hb1);
     cancel = new QPushButton("Cancel",hb1);


     connect(lstBox,SIGNAL(highlighted(const QString &)), line, SLOT(setText(const QString &)));
     connect(ok,SIGNAL(clicked()),this,SLOT(acceptLine()));
     connect(tripoint,SIGNAL(clicked()), this, SLOT(selectFile()));
     connect(cancel,SIGNAL(clicked()),this,SLOT(reject()));
}



void BlockDialog::selectFile()
{
     QString fileName = QFileDialog::getSaveFileName(
	  0,
	  "Block files (*.xml)",
	  this,
	  "Open a meta-block file",
	  "Choose a meta-block file to open" );
     
     if (!fileName.isEmpty())
     {
	  if (fileName.right(4) != ".xml")
	       fileName += ".xml";
	  line->setText(fileName);

     }
}


void BlockDialog::acceptLine()
{
     if (line->text().isEmpty())
	  QMessageBox::information(this,"Empty selection", "You did not select an item nor a file.", QMessageBox::Ok);
     else
	  accept();
}
