/*
  name: transitioncanvas.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __TRANSITIONCANVAS_H__
#define __TRANSITIONCANVAS_H__

/*! \file transitioncanvas.h
 * \author Yoann Petit
 * \date 14 Juin 2005
 * 
 * File describing transition canvas class
 */

//#include "statecanvas.h"
#include <qstring.h>
#include <qcanvas.h>
#include <qpointarray.h>
#include "rtti.h"

#ifndef M_PI
#define M_PI 3.14159265
#endif

/*! \brief Transition CanvasItem description
 * 
 * This is the graphical counterpart of transitions included in state machines
 * \sa MetaStateMachine
 */
class TransitionCanvas : public QCanvasLine
{
public:

     /*! \brief Transitioncanvas constructor.
      *  \param *from NodeItem of source.
      *  \param *to NodeItem of destination.
      *  \param nameTransition Name of the token of the transition.
      */
     TransitionCanvas( QCanvasItem *from, QCanvasItem *to, QString nameTransition );
     ~TransitionCanvas();

     /*! \brief Returns the RTTI of the TransitionCanvas.
      *  \return RTTI of the TransitionCanvas.
      */
     int rtti() const { return RTTI_TRANSITIONCANVAS; }

     /*! \brief Replace arrow when the TransitionCanvas is moving. 
      *  \param dx StateCanvas's moving along the X-axis.
      *  \param dy StateCanvas's moving along the Y-axis.
      *  \param source Put true if it's a moving of the source StateCanvas, false otherwise.
      */
     void setFleche( double dx, double dy,bool source );

     /*! \brief Returns the name of the TransitionCanvas.
      *  \return Name of the TransitionCanvas.
      */
     QString getName() { return tcName; }

     /*! \brief Returns the StateCanvas of source.
      *  \return QCanvasItem. This is the StateCanvas of source. 
      */
     QCanvasItem* getSender() { return tcFrom; }

     /*! \brief Returns the StateCanvas of destination.
      *  \return QCanvasItem. This is the StateCanvas of destination. 
      */
     QCanvasItem* getReceiver() { return tcTo; }

public:
     QCanvasItem *tcFrom; //!< The StateCanvas of source
     QCanvasItem *tcTo; //!< The StateCanvas of destination
     QCanvasText *ct; //!< The label for the name of the transition
     QString tcName; //!< The name of the transition
     QCanvasPolygon *fleche; //!< The arrow of the TransitionCanvas
     QPointArray pa; //!< Three points for define the arrow
};

#endif //__TRANSITIONCANVAS_H__
