/*
  name: sheetdialog.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "sheetdialog.h"
#include <iostream>

#include <qvbox.h>
#include <qmessagebox.h>

using namespace std;

SheetDialog::SheetDialog( QWidget *parent, const char *name, bool newSheet, QString nameSheet)
     : QDialog( parent, name, true, 0)
{
     nSheet = nameSheet;
     ns = newSheet;
     if ( newSheet )
	  setCaption("Nommer cette nouvelle sheet");
     else
	  setCaption("Renommer la sheet '"+nameSheet+"'");
// Mise en place des elements
     QVBox *vb1 = new QVBox( this );
     vb1->resize( 220, 120 );

     QHBox *hb0 = new QHBox( vb1 );
     hb0->setMargin( 5 );
     hb0->setSpacing( 5 );
     hb0->setMaximumHeight(30);
     data = new QLineEdit( hb0 );
     data->setMaximumSize( 200, 25 );
     data->setValidator(0);
     if ( !newSheet )
	  data->setText( nameSheet );

     QHBox *hb1 = new QHBox( vb1 );
     hb1->setMargin( 5 );
     hb1->setSpacing( 5 );
     hb1->setMaximumHeight(40);
     ok = new QPushButton( "Ok", hb1 );
     ok->setMaximumWidth( 60 );    
     connect( ok, SIGNAL(clicked()), SLOT(acceptObject()) );
     cancel = new QPushButton( "Cancel", hb1 );
     cancel->setMaximumWidth(90);
     connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
}

void SheetDialog::acceptObject()
{
     is = false ;
     emit isSheet(data->text(),&is);

     if ( (data->text()).isEmpty() )
	  QMessageBox::information( this, "Pour ajouter une feuille","Il faut nommer cette nouvelle feuille.");
     else {
	  if ( ( is ) && ( data->text() != nSheet ) ) {
	       QMessageBox::information( this, "Information","Cette feuille existe dj!");
	  }
	  else
	  {
	       nSheet = data->text();
	       accept();
	  }
     }
}
