/*
  name: objectdialog.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __OBJECTDIALOG_H__
#define __OBJECTDIALOG_H__

#include <metalibrary/metalibrary.h>
#include <metalibrary/metabase.h>

#include <qdialog.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qlabel.h>

#include "sheetview.h"
 

class ObjectDialog : public QDialog 
{
Q_OBJECT
public:
      ObjectDialog( QWidget *parent, const char *name, MetaLibrary metalib, SheetView* sw=NULL);
~ObjectDialog();
private:
     QPushButton *ok, *cancel;
public slots:
     void acceptObject();
     void textSearch();
     void classClick();
     void objectClick();
signals:
     void explain( const QString& );

private:
     QString fullName(QString s) { return ((sheet->isMacroblock())?(QString(sheet->name())+"::"+s):s); }
     QListView *listClass;
     QListView *listObject;
     QLineEdit *IDSearch;
     QLabel *msgWarning;
     bool classSelect;
     bool isInSheet;
     bool isRegister;
     SheetView* sheet;
};

#endif  // ADDOBJECTDIALOG_H
