/*
  name: listitem.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __LISTITEM_H__
#define __LISTITEM_H__

/*! \file transitioncanvas.h
 * \author Yoann Petit
 * \date 6 Juillet 2005
 * 
 * File describes ListInitItem and ListWireItem
 */

#include <qlistview.h>
#include "initcanvas.h"
#include "wirecanvas.h"

/*! \brief ListInitItem description
 * 
 * This is a class use for the dialog orderdialog.
 *  \sa orderDialog
 */
class ListInitItem : public QListViewItem
{
public:
     /*! \brief ListInitItem constructor
      *  \param *listView List of Items of the dialog orderdialog
      *  \param label1 Object's ID of the init.
      *  \param label2 Slot of the init.
      *  \param *ic InitCanvas of the ListInitItem. 
      */
     ListInitItem( QListView *listView, QString label1, QString label2, InitCanvas * ic) : QListViewItem( listView, label1, label2) { myInit = ic; }
     ~ListInitItem() {};

     /*! \brief Returns the InitCanvas of the ListInitItem.
      *  \return InitCanvas of the ListInitItem.
      */
     InitCanvas* getPointer(){return myInit;}


private:
     InitCanvas* myInit;

};

/*! \brief ListWireItem description
 * 
 * This is a class use for the dialog orderdialog.
 */
class ListWireItem : public QListViewItem
{
public:
        
     /*! \brief ListWireItem constructor
      *  \param *listview List of Items of the dialog orderdialog
      *  \param label1 Object's source of the connection.
      *  \param label2 Signal of the connection.
      *  \param label3 Object's destination of the connection.
      *  \param label4 Slot of the connection.
      *  \param *wc WireCanvas of the ListWireItem. 
      */
     ListWireItem( QListView *listView, QString label1, QString label2, QString label3, QString label4, WireCanvas * wc) : QListViewItem( listView, label1, label2, label3, label4) { myWire = wc; }
     ~ListWireItem() {};

     /*! \brief Returns the WireCanvas of the ListWireItem.
      *  \return WireCanvas of the ListWireItem.
      */
     WireCanvas* getPointer(){return myWire;}


private:
     WireCanvas* myWire;

};

#endif //__LISTITEM_H__

