/*
  name: linewire.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __LINEWIRE_H__
#define __LINEWIRE_H__

/*! \file transitioncanvas.h
 * \author Yoann Petit
 * \date 6 Juillet 2005
 * 
 * File describes LineWire
 */

#include <qcanvas.h>
#include "rtti.h"

/*! \brief LineWire description
 * 
 * This is a class use for conections.
 */

class LineWire : public QCanvasLine
{
public:

     /*! \brief LineWire constructor.
      *  \param *wc WireCanvas of this LineWire..
      */
     LineWire(QCanvasItem* wc) : QCanvasLine(wc->canvas()) { owner = wc; }
     
     /*! \brief Returns the RTTI of the LineWire.
      *  \return RTTI of the LineWire.
      */
     int rtti() const { return RTTI_LINEWIRE; }
     
     /*! \brief Returns the WireCanvas of the LineWire. 
      *  \return WireCanvas of the LineWire.
      */
     QCanvasItem* getOwner() {return owner; }

private:
     QCanvasItem* owner; //!< LineWire's WireCanvas
};

#endif //__LINEWIRE_H__
