/*
  name: gripwire.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __GRIPWIRE_H__
#define __GRIPWIRE_H__

/*! \file transitioncanvas.h
 * \author Yoann Petit
 * \date 6 Juillet 2005
 * 
 * File describes GripWire
 */

#include <qcanvas.h>
#include "rtti.h"

/*! \brief GripWire description
 * 
 * This is a class use for move connections.
 * This is the graphical counterpart of grip for connection
 * \sa WireCanvas
 */
class GripWire : public QCanvasRectangle
{
public:
     GripWire( int n,QCanvasItem* it);
     ~GripWire();
     /*! \brief Returns the RTTI of the GripWire.
      *  \return RTTI of the GripWire. 
      */
     int rtti() const { return RTTI_GRIPWIRE; }

     /*! \brief Defines the number of this GripWire in the WireCanvas. 
      *  \param n Nnumber of this GripWire in the WireCanvas. 
      */
     void setNum( int n ) { num = n; } 

     /*! \brief Returns the WireCanvas of the GripWire.
      *  \return A QCanvasItem. This is the GripWire's WireCanvas.
      */
     QCanvasItem* getWireCanvas() { return wireGrip; }
     
     /*! \brief Moves the others WireCanvas's GripWires.
      *  \param dx GripWire's moving along the X-axis.
      *  \param dy GripWire's moving along the Y-axis.
      */
     void moveGrip(double dx, double dy);
     
     /*! \brief Replaces LineWires when a GripWire is moving.
      */
     void setLine();

     /*! \brief Save the position of the GripWires.
      *  It's use when the user import a project because all objects of a sheet 
      *  have to be created before gripwires.
      *  \param x GripWire's position along the X-axis.
      *  \param y GripWire's position along the Y-axis.
      */
     void savePoint(double x, double y) { tempX = x; tempY = y; }
     
     /*! \brief Move the GripWire at the position's saving.
      */
     void setPoint() { moveGrip(tempX - x(), tempY-y()); setLine(); }

private:
     void moveGrip0( double dx);
     void moveGrip1( double dx, double dy);
     void moveGrip2( double dx, double dy);
     void moveGrip3( double dx);
     QCanvasItem* wireGrip; //!< GripWire's WireCanvas.
     int num; //!< Number of this GripWire in the WireCanvas.
     double tempX; //!< GripWire's position along the X-axis.
     double tempY; //!< GripWire's position along the Y-axis.
};

#endif //__GRIPWIRE_H__
