/*
  name: execdialog.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __EXECDIALOG_H__
#define __EXECDIALOG_H__

#include <qdialog.h>
#include <qprocess.h>
#include <qpushbutton.h>
#include <qtextedit.h>
//#include <qmenubar.h>


/*! \brief A dialog window that runs the program metaruntime with the currently designed application
 * 
 * This dialog window will broadcast the  reject() signal if it failed to launch the metaruntime program.
 * Otherwise, the signal accept() will be broadcasted.
 * \author Jean-Yves Didier
 * \date February, 15th 2006
 */
class ExecDialog : public QDialog
{
Q_OBJECT

public:
/*! \brief Constructor
 * 
 * This dialog window starts metaruntime.
 * \param parent parent QT widget
 * \param name put what you want here
 * \param projectPath the path where the current project is stored.
 */
ExecDialog(QWidget* parent, const char* name, QString projectPath); 
~ExecDialog(); //!< Destructor

public slots:
     void kill();//!< \brief Kills the metaruntime program
void restart();//!< \breif Restarts the metaruntime program
void finish(); //!< \brief triggered when the metaruntime program has finished.
void addSTDOut(); //!< \brief will fetch what is written through metaruntime stdout and print it in green.
void addSTDErr(); //!< \brief will fetch what is written through metaruntime stdout and print it in red.
void loadFile(); //!< \brief opens a dialog box to open files.
void changeEngine(); //!< \brief opens a dialog to choose runtime engine.
void resetEngine(); //!< \brief resets the usual engine

private:
bool fetchEngine();
void setEngine();
QPushButton* bKill;
QPushButton* bRestart;
QPushButton* bClose;
QTextEdit* teOut;
QProcess* process;
//QMenuBar* menu;

QString paramPath;
QString runtimePath;

};




#endif //__EXECDIALOG_H__
