/*
  name: definesdialog.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __DEFINESDIALOG_H__
#define __DEFINESDIALOG_H__

#include <metalibrary/metabase.h>

#include <qdialog.h>
#include <qtable.h>
#include <qlineedit.h>
#include <qvalidator.h>
#include <qpushbutton.h>
#include <qstringlist.h>

class QIntTableItem : public QTableItem
{
public:
     QIntTableItem(QTable * table, EditType et ) : QTableItem(table,et) { setReplaceable(false);}

     QWidget* createEditor() const
	  { 
	       QLineEdit* le = (QLineEdit*)QTableItem::createEditor();
	       le->setValidator( new QIntValidator(le) );
	       return le;
	  }
};

class QFloatTableItem : public QTableItem
{
public:
     QFloatTableItem(QTable * table, EditType et ) : QTableItem(table,et) { setReplaceable(false);}

     QWidget* createEditor() const
	  { 
	       QLineEdit* le = (QLineEdit*)QTableItem::createEditor();
	       le->setValidator( new QDoubleValidator(le) );
	       return le;
	  }
};

class QPathTableItem : public QTableItem
{
public:
     QPathTableItem(QTable* table, EditType et) : QTableItem(table,et) { setReplaceable(false); }
     QWidget* createEditor() const { return NULL; } 


};



class DefinesDialog : public QDialog
{
Q_OBJECT

public:
DefinesDialog(QWidget* parent, const char* name);

virtual void show();


public slots:
     void addNewLine();
void delLine();
void changeValue(int row, int col);
void commitChanges();
void fill();


private:
QTable* table;
QPushButton* ok,* cancel, *newDefine, *delDefine;
QStringList colHeaders;

};

#endif //__DEFINESDIALOG_H__
